/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionValue;
import org.openide.ErrorManager;
import org.xml.sax.Attributes;

public class OptionSetXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private static final String TAG_OPTION = "option";
    private static final String ATTR_OPTION_NAME = "name";
    private static final String ATTR_OPTION_VALUE = "value";
    private OptionSet optionSet;

    public OptionSetXMLCodec(OptionSet optionSet) {
        this.optionSet = optionSet;
    }

    public String tag() {
        return this.optionSet.tag();
    }

    public void start(Attributes atts) throws VersionException {
        String what = this.optionSet.description();
        int maxVersion = 1;
        this.checkVersion(atts, what, maxVersion);
    }

    public void end() {
    }

    public void startElement(String element, Attributes atts) {
        if (TAG_OPTION.equals(element)) {
            String name = atts.getValue(ATTR_OPTION_NAME);
            OptionValue o = this.optionSet.byName(name);
            if (o != null) {
                String value = atts.getValue(ATTR_OPTION_VALUE);
                o.setInitialValue(value);
            } else {
                ErrorManager.getDefault().log("Warning: unknown option " + name);
            }
        }
    }

    public void endElement(String element, String currentText) {
    }

    public void encode(XMLEncoderStream xes) {
        xes.elementOpen(this.tag());
        for (int ox = 0; ox < this.optionSet.values().size(); ++ox) {
            OptionValue o = this.optionSet.values().get(ox);
            this.writeOption(xes, o);
        }
        xes.elementClose(this.tag());
    }

    private void writeOption(XMLEncoderStream xes, OptionValue o) {
        if (!o.type().persist(o)) {
            return;
        }
        String xmlval = o.get();
        String defaultval = o.getDefaultValue();
        String option_name = o.type().getName();
        if (!option_name.equals("stack_max_size") && !xmlval.equals(defaultval)) {
            AttrValuePair[] optionAttrs = new AttrValuePair[]{new AttrValuePair(ATTR_OPTION_NAME, option_name), new AttrValuePair(ATTR_OPTION_VALUE, xmlval)};
            xes.element(TAG_OPTION, optionAttrs);
        }
    }
}

