/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHost;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHostList;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.HostPanel;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.LastLocation;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.MasterDetailView;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.MasterView;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordList;
import org.openide.util.HelpCtx;

public class HostListEditor
extends MasterDetailView {
    private final CustomizableHostList original = CustomizableHostList.getInstance();
    private final RecordList<CustomizableHost> editable = this.original.cloneList();
    private JDialog dialog;
    private static LastLocation lastLocation = new LastLocation(700, 0);

    public void showDialog(Component parent) {
        this.dialog = IpeUtils.createDialog(parent, this.getTitleText(), (JComponent)((Object)this));
        this.installInDialog(this.dialog);
        Catalog.setAccessibleDescription(this.dialog, "ACSD_Hosts");
        this.dialog.setVisible(true);
    }

    public HostListEditor() {
        super(null, 4, null);
        CustomizableHost localhost = this.editable.getRecordAt(0);
        HostPanel detailView = new HostPanel(localhost);
        MasterView<CustomizableHost> masterView = new MasterView<CustomizableHost>(this.editable, detailView);
        this.addMasterView(masterView);
        this.addDetailView(detailView);
    }

    protected String getTitleText() {
        return Catalog.get("REMOTE_DIALOG_TITLE");
    }

    protected String getGuidanceText() {
        return Catalog.get("REMOTE_DIALOG_GUIDANCE_TXT");
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("RemoteHost");
    }

    @Override
    public void handleCommit() {
        Host lastone = this.editable.getRecordAt(this.editable.getCurrentRecordIndex());
        this.original.copyList(this.editable, lastone.getHostName());
    }

    @Override
    public void handleClose() {
        this.closeDialog();
    }

    private void closeDialog() {
        lastLocation.rememberFrom(this.dialog);
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
    }
}

