/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchVariable;
import org.netbeans.modules.cnd.debugger.common2.values.VariableValue;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.AbstractExpandToolTipAction;
import org.netbeans.spi.debugger.ui.PinWatchUISupport;

public class NativePinWatchValueProvider
implements PinWatchUISupport.ValueProvider,
PinWatchUISupport.ValueProvider.ValueChangeListener {
    public static final String ID = "NativePinWatchValueProvider";
    private final Map<Watch, PinWatchUISupport.ValueProvider.ValueChangeListener> valueListeners = new HashMap<Watch, PinWatchUISupport.ValueProvider.ValueChangeListener>();
    private final NativeDebugger debugger;

    public NativePinWatchValueProvider(ContextProvider lookupProvider) {
        this.debugger = (NativeDebugger)lookupProvider.lookupFirst(null, NativeDebugger.class);
        NativeDebuggerManager.get().registerPinnedWatchesUpdater(this.debugger, this);
    }

    protected final NativeDebugger getDebugger() {
        return this.debugger;
    }

    public String getId() {
        return ID;
    }

    public String getValue(Watch watch) {
        for (WatchVariable watchVar : this.debugger.getWatches()) {
            if (!watchVar.getNativeWatch().watch().getExpression().equals(watch.getExpression())) continue;
            Variable v = (Variable)((Object)watchVar);
            VariableValue value = new VariableValue(v.getAsText(), v.getDelta());
            return value.toString();
        }
        return "";
    }

    public String getEditableValue(Watch watch) {
        return null;
    }

    private boolean isExpandable(Watch watch) {
        for (WatchVariable watchVar : this.debugger.getWatches()) {
            if (!watchVar.getNativeWatch().watch().getExpression().equals(watch.getExpression())) continue;
            Variable v = (Variable)((Object)watchVar);
            return !v.isLeaf;
        }
        return false;
    }

    public Action[] getHeadActions(Watch watch) {
        if (!this.isExpandable(watch)) {
            return new Action[0];
        }
        return new Action[]{new ExpandAction(this.debugger, watch)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangeListener(Watch watch, PinWatchUISupport.ValueProvider.ValueChangeListener chl) {
        Map<Watch, PinWatchUISupport.ValueProvider.ValueChangeListener> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.put(watch, chl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetChangeListener(Watch watch) {
        Map<Watch, PinWatchUISupport.ValueProvider.ValueChangeListener> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.remove(watch);
        }
    }

    public void valueChanged(Watch watch) {
        PinWatchUISupport.ValueProvider.ValueChangeListener listener = this.valueListeners.get(watch);
        if (listener != null) {
            listener.valueChanged(watch);
        }
    }

    protected static class ExpandAction
    extends AbstractExpandToolTipAction {
        private final NativeDebugger debugger;
        private final Watch watch;

        public ExpandAction(NativeDebugger debugger, Watch watch) {
            this.debugger = debugger;
            this.watch = watch;
        }

        protected void openTooltipView() {
            this.debugger.evaluateInOutline(this.watch.getExpression());
        }
    }
}

