/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.javacard.project.deps.Dependencies;
import org.netbeans.modules.javacard.project.deps.Dependency;
import org.netbeans.modules.javacard.project.deps.DependencyKind;
import org.netbeans.modules.javacard.project.deps.DeploymentStrategy;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class DependenciesParser
extends DefaultHandler {
    private boolean inDependencies;
    private boolean inDependency;
    public static final String DEP = "dependency";
    public static final String DEPS = "dependencies";
    public static final String KIND = "kind";
    public static final String DEPLOYMENT_STRATEGY = "deployment";
    public static final String ID = "id";
    private final Dependencies deps = new Dependencies();

    private DependenciesParser() {
    }

    static Dependencies parse(InputSource in) throws SAXException, ParserConfigurationException, IOException {
        DependenciesParser p = new DependenciesParser();
        SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)p);
        return p.deps;
    }

    static Dependencies parse(Element cfgRoot) throws IOException {
        NodeList l = cfgRoot.getElementsByTagNameNS("http://www.netbeans.org/ns/javacard-project/3", DEPS);
        if (l.getLength() == 0) {
            throw new IOException("No dependencies section in project configuration");
        }
        if (l.getLength() > 1) {
            throw new IOException("Multiple dependencies sections in project configuration");
        }
        Dependencies deps = new Dependencies();
        NodeList nl = ((Element)l.item(0)).getElementsByTagName(DEP);
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element depElement = (Element)nl.item(i);
            String id = depElement.getAttribute(ID);
            if (id == null) {
                throw new IOException("Missing ID for dependency element " + depElement);
            }
            String strategy = depElement.getAttribute(DEPLOYMENT_STRATEGY);
            DeploymentStrategy strat = DeploymentStrategy.valueOf(strategy);
            if (strat == null) {
                throw new IOException("Missing Deployment Strategy for " + depElement);
            }
            String k = depElement.getAttribute(KIND);
            if (k == null) {
                throw new IOException("Missing dependency kind for " + depElement);
            }
            DependencyKind kind = DependencyKind.valueOf(k);
            Dependency dep = new Dependency(id, kind, strat);
            deps.add(dep);
        }
        return deps;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean nowInDependencies = DEPS.equals(qName);
        if (this.inDependencies != nowInDependencies) {
            this.inDependencies = nowInDependencies;
            if (this.inDependencies) {
                return;
            }
        }
        boolean nowInDependency = DEP.equals(qName);
        if (this.inDependency && nowInDependency) {
            throw new SAXException("Nested dependencies not supported");
        }
        this.inDependency = nowInDependency;
        if (this.inDependency) {
            Dependency d = this.parseDependency(attributes);
            this.deps.add(d);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean endDependencies = DEPS.equals(qName);
        if (endDependencies) {
            this.inDependencies = false;
            return;
        }
        boolean endDependency = DEP.equals(qName);
        if (endDependency) {
            this.inDependency = false;
            return;
        }
    }

    private Dependency parseDependency(Attributes a) throws SAXException {
        String k = a.getValue(KIND);
        if (k == null) {
            throw new SAXException("kind missing from dependency attributes " + this.atts2s(a));
        }
        DependencyKind kind = DependencyKind.parse(k);
        String depStrategy = a.getValue(DEPLOYMENT_STRATEGY);
        if (depStrategy == null) {
            throw new SAXException("deployment missing from dependency attributes " + this.atts2s(a));
        }
        DeploymentStrategy strategy = DeploymentStrategy.valueOf(depStrategy);
        String id = a.getValue(ID);
        if (id == null) {
            throw new SAXException("id missing from dependency attributes " + this.atts2s(a));
        }
        return new Dependency(id, kind, strategy);
    }

    private String atts2s(Attributes a) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < a.getLength(); ++i) {
            String qName = a.getQName(i);
            sb.append(qName);
            sb.append('=');
            sb.append('\"');
            String val = a.getValue(qName);
            sb.append(val);
            sb.append('\"');
            sb.append(" ");
        }
        return sb.toString();
    }
}

