/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.netbeans.modules.cnd.settings.ShellSettings;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ShellExecSupport
extends ExecutionSupport {
    private static final String PROP_RUN_DIRECTORY = "rundirectory";
    private static final String PROP_SHELL_COMMAND = "shellcommand";
    private static final String PROP_ENVIRONMENT = "environment";

    public ShellExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    @Override
    public void addProperties(Sheet.Set set) {
        set.put(this.createParamsProperty("params", this.getString("PROP_fileParams"), this.getString("HINT_fileParams")));
        set.put(this.createRunDirectoryProperty());
        set.put(this.createShellCommandProperty());
        set.put(this.createEnvironmentProperty(PROP_ENVIRONMENT, this.getString("PROP_ENVIRONMENT"), this.getString("HINT_ENVIRONMENT")));
    }

    private PropertySupport<String> createRunDirectoryProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_RUN_DIRECTORY, String.class, this.getString("PROP_RUN_DIRECTORY"), this.getString("HINT_RUN_DIRECTORY")){

            public String getValue() {
                return ShellExecSupport.this.getRunDirectory();
            }

            public void setValue(String val) {
                ShellExecSupport.this.setRunDirectory(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return ShellExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    private PropertySupport<String> createShellCommandProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_SHELL_COMMAND, String.class, this.getString("PROP_SHELL_COMMAND"), this.getString("HINT_SHELL_COMMAND")){

            public String getValue() {
                return ShellExecSupport.this.getShellCommand();
            }

            public void setValue(String val) {
                ShellExecSupport.this.setShellCommand(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return ShellExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getRunDirectory() {
        String dir = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (dir == null) {
            dir = ".";
            this.setRunDirectory(dir);
        }
        return dir;
    }

    public void setRunDirectory(String dir) {
        block2: {
            FileObject fo = this.getEntry().getFile();
            try {
                fo.setAttribute(PROP_RUN_DIRECTORY, (Object)dir);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    public String getShellCommand() {
        String shellCommand = (String)this.getEntry().getFile().getAttribute(PROP_SHELL_COMMAND);
        if (shellCommand == null || shellCommand.length() == 0) {
            shellCommand = "";
        }
        return shellCommand;
    }

    public String[] getShellCommandAndArgs(FileObject fo) {
        String[] argvParsed;
        String ext;
        String shellCommand = this.getShellCommand();
        if (shellCommand.isEmpty()) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(fo.getInputStream(), Charset.defaultCharset()));
                String firstLine = in.readLine();
                if (firstLine != null && firstLine.startsWith("#!") && firstLine.length() > 2) {
                    int i = 2;
                    while (Character.isWhitespace(firstLine.charAt(i))) {
                        ++i;
                    }
                    shellCommand = firstLine.substring(i);
                }
                in.close();
            }
            catch (Exception in) {
                // empty catch block
            }
        }
        if (shellCommand.isEmpty() && (ext = fo.getExt()) != null && ext.length() > 0) {
            if ((ext.equals("bat") || ext.equals("cmd")) && Utilities.isWindows()) {
                argvParsed = new String[]{""};
                return argvParsed;
            }
            shellCommand = "/bin/" + ext;
            if (!new File(shellCommand).exists()) {
                shellCommand = null;
            }
        }
        if (shellCommand == null || shellCommand.length() == 0) {
            shellCommand = ShellSettings.getDefault().getDefaultShellCommand();
        }
        argvParsed = Utilities.parseParameters((String)shellCommand);
        return argvParsed;
    }

    public void setShellCommand(String command) {
        block2: {
            FileObject fo = this.getEntry().getFile();
            try {
                fo.setAttribute(PROP_SHELL_COMMAND, (Object)command);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private String getString(String s) {
        return NbBundle.getMessage(ShellExecSupport.class, (String)s);
    }
}

