/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.status;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.status.GitVersioningTopComponent;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class StatusAction
extends GitAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/remote/resources/icons/show_changes.png";

    public StatusAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected final void performContextAction(Node[] nodes) {
        VCSContext context = this.getCurrentContext(nodes);
        this.performContextAction(context);
    }

    public void performContextAction(VCSContext context) {
        GitVersioningTopComponent stc = GitVersioningTopComponent.findInstance();
        stc.setContentTitle(VCSFileProxySupport.getContextDisplayName((VCSContext)context));
        stc.setContext(context);
        stc.open();
        stc.requestActive();
    }

    public final GitProgressSupport scanStatus(VCSContext context) {
        Set<VCSFileProxy> repositories = GitUtils.getRepositoryRoots(context);
        if (repositories.isEmpty()) {
            return null;
        }
        final HashMap<VCSFileProxy, List<VCSFileProxy>> toRefresh = new HashMap<VCSFileProxy, List<VCSFileProxy>>(repositories.size());
        for (VCSFileProxy repository : repositories) {
            GitUtils.logRemoteRepositoryAccess(repository);
            toRefresh.put(repository, Arrays.asList(GitUtils.filterForRepository(context, repository)));
        }
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                long t = 0L;
                if (Git.STATUS_LOG.isLoggable(Level.FINE)) {
                    t = System.currentTimeMillis();
                    Git.STATUS_LOG.log(Level.FINE, "StatusAction.scanStatus(): started for {0}", toRefresh.keySet());
                }
                Git.getInstance().getFileStatusCache().refreshAllRoots(toRefresh, this.getProgressMonitor());
                if (Git.STATUS_LOG.isLoggable(Level.FINE)) {
                    Git.STATUS_LOG.log(Level.FINE, "StatusAction.scanStatus(): lasted {0}", System.currentTimeMillis() - t);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(), null, NbBundle.getMessage(StatusAction.class, (String)"LBL_ScanningStatuses"));
        return supp;
    }
}

