/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.common.event.SimpleProfilingStateAdapter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopupFactory;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.actions.HeapDumpAction;
import org.netbeans.modules.profiler.actions.RunGCAction;
import org.netbeans.modules.profiler.actions.TakeThreadDumpAction;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.v2.Bundle;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerFeatures;
import org.netbeans.modules.profiler.v2.ProfilerPlugins;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.ProfilerSessions;
import org.netbeans.modules.profiler.v2.SnapshotsWindow;
import org.netbeans.modules.profiler.v2.impl.FeaturesView;
import org.netbeans.modules.profiler.v2.impl.ProfilerStatus;
import org.netbeans.modules.profiler.v2.impl.WelcomePanel;
import org.netbeans.modules.profiler.v2.ui.DropdownButton;
import org.netbeans.modules.profiler.v2.ui.StayOpenPopupMenu;
import org.netbeans.modules.profiler.v2.ui.ToggleButtonMenuItem;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class ProfilerWindow
extends ProfilerTopComponent {
    private final ProfilerSession session;
    private ProfilerFeatures features;
    private ProfilerPlugins plugins;
    private ProfilerToolbar toolbar;
    private ProfilerToolbar featureToolbar;
    private ProfilerToolbar applicationToolbar;
    private JPanel container;
    private FeaturesView featuresView;
    private PopupButton configure;
    private DropdownButton start;
    private JButton stop;
    private SettingsPresenter settingsButton;
    private AttachSettings attachSettings;
    private ProfilerStatus status;
    private boolean profilePopupVisible;
    private final String ID = "ProfilerWindow";
    boolean closing = false;
    private AccessibleContext accessibleContext;

    ProfilerWindow(ProfilerSession session) {
        this.session = session;
        this.updateWindowName();
        this.updateWindowIcon();
        this.createUI();
    }

    void updateSession() {
        this.updateWindowName();
        if (this.start != null) {
            this.start.setText(this.session.isAttach() ? Bundle.ProfilerWindow_attach() : Bundle.ProfilerWindow_profile());
        }
    }

    void selectFeature(ProfilerFeature feature) {
        if (this.featuresView != null) {
            this.featuresView.selectFeature(feature);
        }
    }

    private void createUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.setFocusable(false);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.add(this.toolbar.getComponent(), "North");
        final JLabel loading = new JLabel(Bundle.ProfilerWindow_loadingSession());
        loading.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.toolbar.add((Component)loading);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ProfilerWindow.this.loadSessionSettings();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerWindow.this.toolbar.remove((Component)loading);
                        ProfilerWindow.this.popupulateUI();
                    }
                });
            }
        });
    }

    private void loadSessionSettings() {
        this.features = this.session.getFeatures();
        this.plugins = this.session.getPlugins();
        Properties p = new Properties();
        try {
            ProfilerStorage.loadProjectProperties((Properties)p, (Lookup.Provider)this.session.getProject(), (String)"attach");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!p.isEmpty()) {
            this.attachSettings = new AttachSettings();
            this.attachSettings.load((Map)p);
        }
    }

    private void popupulateUI() {
        this.configure = new PopupButton(Bundle.ProfilerWindow_configure()){

            protected void displayPopup() {
                ProfilerWindow.this.displayPopupImpl();
            }
        };
        this.configure.setToolTipText(Bundle.ProfilerWindow_configureTooltip());
        if (UIUtils.isAquaLookAndFeel()) {
            this.configure.putClientProperty((Object)"JComponent.sizeVariant", (Object)"regular");
        }
        this.toolbar.add((Component)this.configure);
        String command = this.session.isAttach() ? Bundle.ProfilerWindow_attach() : Bundle.ProfilerWindow_profile();
        this.start = new DropdownButton(command, Icons.getIcon((String)"GeneralIcons.Start"), true){

            @Override
            public void displayPopup() {
                ProfilerWindow.this.displayPopupImpl();
            }

            @Override
            protected void performAction() {
                ProfilerWindow.this.performStartImpl();
            }
        };
        this.start.setToolTipText(Bundle.ProfilerWindow_profileTooltip());
        this.start.setPushedToolTipText(Bundle.ProfilerWindow_profileRunningTooltip());
        this.start.setPopupToolTipText(Bundle.ProfilerWindow_configureTooltip());
        this.toolbar.add((Component)this.start);
        this.stop = new JButton(ProfilerSessions.StopAction.getInstance());
        this.stop.setHideActionText(true);
        this.toolbar.add((Component)this.stop);
        this.toolbar.addFiller();
        this.settingsButton = new SettingsPresenter();
        this.toolbar.add((Component)this.settingsButton);
        this.container = new JPanel(new BorderLayout(0, 0));
        this.add(this.container, "Center");
        WelcomePanel welcomePanel = new WelcomePanel(this.configure.getText(), this.start.getText(), this.features.getAvailable()){

            @Override
            public void highlightItem(String text) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerWindow.this.configure.doClick(85);
                    }
                });
            }
        };
        boolean showHint = ProfilerIDESettings.getInstance().getShowNoDataHint();
        this.featuresView = new FeaturesView(welcomePanel, showHint ? command : null);
        this.container.add((Component)this.featuresView, "Center");
        this.features.addListener(new ProfilerFeatures.Listener(){

            @Override
            void featuresChanged(ProfilerFeature changed) {
                ProfilerWindow.this.updateFeatures(changed);
            }

            @Override
            void settingsChanged(boolean valid) {
                ProfilerWindow.this.updateSettings(valid);
            }
        });
        this.updateFeatures(null);
        this.updateSettings(this.features.settingsValid());
        this.featuresView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProfilerWindow.this.updateFeatureToolbar();
            }
        });
        this.updateFeatureToolbar();
        this.session.addListener((ProfilingStateListener)new SimpleProfilingStateAdapter(){

            public void update() {
                ProfilerWindow.this.updateWindowIcon();
                ProfilerWindow.this.updateButtons();
            }
        });
        this.updateButtons();
        this.registerActions();
        this.status = ProfilerStatus.forSession(this.session);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (ProfilerWindow.this.isShowing()) {
                        ProfilerWindow.this.status.startSessionLogging();
                    } else {
                        ProfilerWindow.this.status.stopSessionLogging();
                    }
                }
            }
        });
        if (this.isShowing()) {
            this.status.startSessionLogging();
        }
    }

    private void registerActions() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        String filterKey = "filter-action-key";
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel resultsUI;
                ProfilerFeature feature = ProfilerWindow.this.featuresView.getSelectedFeature();
                JPanel jPanel = resultsUI = feature == null ? null : feature.getResultsUI();
                if (resultsUI == null) {
                    return;
                }
                Action action = resultsUI.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
        String findKey = "find-action-key";
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel resultsUI;
                ProfilerFeature feature = ProfilerWindow.this.featuresView.getSelectedFeature();
                JPanel jPanel = resultsUI = feature == null ? null : feature.getResultsUI();
                if (resultsUI == null) {
                    return;
                }
                Action action = resultsUI.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
    }

    private void updateWindowName() {
        Lookup.Provider project = this.session.getProject();
        if (project == null) {
            this.setDisplayName(Bundle.ProfilerWindow_captionExternal());
        } else {
            String projectN = ProjectUtilities.getDisplayName((Lookup.Provider)project);
            FileObject file = this.session.getFile();
            this.setDisplayName(file == null ? Bundle.ProfilerWindow_captionProject(projectN) : Bundle.ProfilerWindow_captionFile(projectN, file.getNameExt()));
        }
    }

    private void updateWindowIcon() {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProfilerWindow.this.session.inProgress()) {
                    ProfilerWindow.this.setIcon(Icons.getImage((String)"ProfilerIcons.ProfileRunning"));
                } else {
                    ProfilerWindow.this.setIcon(Icons.getImage((String)"ProfilerIcons.ProfileInactive"));
                }
            }
        });
    }

    private void updateButtons() {
        int state = this.session.getState();
        this.start.setPushed(state != 1);
        this.start.setPopupEnabled(state != 128);
    }

    private void updateFeatures(ProfilerFeature changed) {
        ProfilerFeature restore = this.featuresView.getSelectedFeature();
        this.featuresView.removeFeatures();
        Set<ProfilerFeature> selected = this.features.getActivated();
        for (ProfilerFeature feature : selected) {
            this.featuresView.addFeature(feature);
        }
        if (changed != null && selected.contains(changed)) {
            this.featuresView.selectFeature(changed);
        } else {
            this.featuresView.selectFeature(restore);
        }
        this.featuresView.repaint();
    }

    private void updateSettings(boolean valid) {
        this.start.setEnabled(valid);
        boolean _configure = this.features.getActivated().isEmpty();
        this.start.setVisible(!_configure);
        this.stop.setVisible(!_configure);
        this.configure.setVisible(_configure);
        new Timer(0, null){
            {
                this.setRepeats(false);
                this.setInitialDelay(50);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerWindow.this.updateFocus();
            }
        }.start();
        if (this.session.inProgress()) {
            this.session.doModify(this.features.getSettings());
        }
    }

    private void updateFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focused != null) {
                    if (ProfilerWindow.this.profilePopupVisible) {
                        return;
                    }
                    if (ProfilerPopupFactory.isInPopup((Component)focused)) {
                        return;
                    }
                    if (ProfilerWindow.this.isAncestorOf(focused)) {
                        return;
                    }
                }
                Object foc = ProfilerWindow.this.configure.isVisible() ? ProfilerWindow.this.configure : ProfilerWindow.this.start;
                SwingUtilities.invokeLater(new Runnable((Component)foc){
                    final /* synthetic */ Component val$foc;
                    {
                        this.val$foc = component;
                    }

                    @Override
                    public void run() {
                        this.val$foc.requestFocusInWindow();
                    }
                });
            }
        });
    }

    private void updateFeatureToolbar() {
        ProfilerFeature selected;
        if (this.featureToolbar != null) {
            this.toolbar.remove(this.featureToolbar);
        }
        if (this.applicationToolbar != null) {
            this.toolbar.remove(this.applicationToolbar);
        }
        ProfilerToolbar profilerToolbar = this.featureToolbar = (selected = this.featuresView.getSelectedFeature()) == null ? null : selected.getToolbar();
        if (this.featureToolbar != null) {
            this.toolbar.add(this.featureToolbar, this.toolbar.getComponentCount() - 2);
        }
        this.settingsButton.setFeature(selected);
        if (selected != null) {
            this.toolbar.add(this.getApplicationToolbar(), this.toolbar.getComponentCount() - 2);
        } else {
            this.applicationToolbar = null;
        }
        this.doLayout();
        this.repaint();
    }

    private ProfilerToolbar getApplicationToolbar() {
        if (this.applicationToolbar == null) {
            this.applicationToolbar = ProfilerToolbar.create((boolean)true);
            this.applicationToolbar.addSpace(2);
            this.applicationToolbar.addSeparator();
            this.applicationToolbar.addSpace(5);
            GrayLabel apLabel = new GrayLabel(Bundle.ProfilerWindow_application());
            this.applicationToolbar.add((Component)apLabel);
            this.applicationToolbar.addSpace(2);
            JButton apThreadDumpButton = new JButton((Action)((Object)TakeThreadDumpAction.getInstance()));
            apThreadDumpButton.setHideActionText(true);
            this.applicationToolbar.add((Component)apThreadDumpButton);
            this.applicationToolbar.addSpace(3);
            JButton apHeapDumpButton = new JButton((Action)((Object)HeapDumpAction.getInstance()));
            apHeapDumpButton.setHideActionText(true);
            this.applicationToolbar.add((Component)apHeapDumpButton);
            this.applicationToolbar.addSpace(3);
            JButton apGCButton = new JButton((Action)((Object)RunGCAction.getInstance()));
            apGCButton.setHideActionText(true);
            this.applicationToolbar.add((Component)apGCButton);
        }
        return this.applicationToolbar;
    }

    private boolean configureAttachSettings(boolean partially) {
        AttachSettings settings = AttachWizard.getDefault().configure(this.attachSettings, partially);
        if (settings == null) {
            return false;
        }
        this.attachSettings = settings;
        final AttachSettings as = new AttachSettings();
        this.attachSettings.copyInto(as);
        final Lookup.Provider lp = this.session.getProject();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Properties p = new Properties();
                as.store((Map)p);
                try {
                    ProfilerStorage.saveProjectProperties((Properties)p, (Lookup.Provider)lp, (String)"attach");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        return true;
    }

    private void performStartImpl() {
        this.featuresView.resetNoDataHint();
        this.start.setPushed(true);
        final ProfilingSettings _profilingSettings = this.features.getSettings();
        if (_profilingSettings == null) {
            ProfilerDialogs.displayError((String)Bundle.ProfilerWindow_noFeature());
            this.start.setPushed(false);
            return;
        }
        if (this.session.isAttach()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (AttachWizard.getDefault().configured(ProfilerWindow.this.attachSettings)) {
                        ProfilerWindow.this.performDoStartImpl(_profilingSettings, ProfilerWindow.this.attachSettings);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!ProfilerWindow.this.configureAttachSettings(false)) {
                                    ProfilerWindow.this.start.setPushed(false);
                                } else {
                                    ProfilerWindow.this.performDoStartImpl(_profilingSettings, ProfilerWindow.this.attachSettings);
                                }
                            }
                        });
                    }
                }
            });
        } else {
            this.performDoStartImpl(_profilingSettings, null);
        }
    }

    private void performDoStartImpl(final ProfilingSettings ps, final AttachSettings as) {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ProfilerWindow.this.session.doStart(ps, as)) {
                    ProfilerWindow.this.start.setPushed(false);
                }
            }
        });
    }

    private void displayPopupImpl() {
        GridBagConstraints c;
        final Set<ProfilerFeature> _features = this.features.getAvailable();
        final Set<ProfilerFeature> _selected = this.features.getActivated();
        final ArrayList<19> _items = new ArrayList<19>();
        final ProfilerFeatures.Listener listener = new ProfilerFeatures.Listener(){

            @Override
            void featuresChanged(ProfilerFeature changed) {
                int index = 0;
                for (ProfilerFeature feature : _features) {
                    ToggleButtonMenuItem item;
                    if ((item = (ToggleButtonMenuItem)_items.get(index++)) == null) {
                        item = (ToggleButtonMenuItem)_items.get(index++);
                    }
                    item.setPressed(_selected.contains(feature));
                }
            }

            @Override
            void settingsChanged(boolean valid) {
            }
        };
        final StayOpenPopupMenu popup = new StayOpenPopupMenu(){

            @Override
            public void setVisible(boolean visible) {
                if (visible) {
                    ProfilerWindow.this.features.addListener(listener);
                } else {
                    ProfilerWindow.this.features.removeListener(listener);
                }
                super.setVisible(visible);
                ProfilerWindow.this.profilePopupVisible = visible;
                if (!visible) {
                    ProfilerWindow.this.updateFocus();
                }
            }
        };
        popup.setLayout(new GridBagLayout());
        if (!UIUtils.isAquaLookAndFeel()) {
            popup.setForceBackground(true);
            Color background = UIUtils.getProfilerResultsBackground();
            popup.setBackground(new Color(background.getRGB()));
        }
        int lastPosition = -1;
        for (final ProfilerFeature feature : _features) {
            int currentPosition = feature.getPosition();
            if (lastPosition == -1) {
                lastPosition = currentPosition;
            }
            if (currentPosition - lastPosition > 1) {
                _items.add(null);
            }
            lastPosition = currentPosition;
            _items.add(new ToggleButtonMenuItem(feature.getName(), feature.getIcon()){
                {
                    super(text, icon);
                    this.setPressed(_selected.contains(feature));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerWindow.this.features.toggleActivated(feature);
                    if (ProfilerWindow.this.features.isSingleFeatured() && this.isPressed()) {
                        popup.setVisible(false);
                    }
                }
            });
        }
        boolean _project = this.session.getProject() != null;
        boolean _attach = this.session.isAttach();
        JMenuItem attachProject = null;
        if (_attach) {
            String nameA = _project ? Bundle.ProfilerWindow_setupAttachProject() : Bundle.ProfilerWindow_setupAttachProcess();
            attachProject = new JMenuItem(nameA){
                {
                    this.setEnabled(!ProfilerWindow.this.session.inProgress());
                }

                @Override
                protected void fireActionPerformed(ActionEvent event) {
                    ProfilerWindow.this.configureAttachSettings(true);
                }
            };
        }
        StayOpenPopupMenu.CheckBoxItem singleFeature = new StayOpenPopupMenu.CheckBoxItem(Bundle.ProfilerWindow_multipleFeatures()){
            {
                this.setSelected(!ProfilerWindow.this.features.isSingleFeatured());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                ProfilerWindow.this.features.setSingleFeatured(!this.isSelected());
            }
        };
        StayOpenPopupMenu.CheckBoxItem usePPoints = new StayOpenPopupMenu.CheckBoxItem(Bundle.ProfilerWindow_usePPoints()){
            {
                this.setSelected(ProfilerWindow.this.features.getUseProfilingPoints());
                this.setEnabled(!ProfilerWindow.this.session.inProgress());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                ProfilerWindow.this.features.setUseProfilingPoints(this.isSelected());
            }
        };
        int left = 12;
        int labl = 5;
        int y = 0;
        if (_attach) {
            JLabel projectL = new JLabel(Bundle.ProfilerWindow_targetSection(), 10);
            projectL.setFont(popup.getFont().deriveFont(1));
            c = new GridBagConstraints();
            c.gridy = y++;
            c.insets = new Insets(5, labl, 5, 5);
            c.fill = 2;
            popup.add((Component)projectL, c);
            c = new GridBagConstraints();
            c.gridy = y++;
            c.gridx = 0;
            c.insets = new Insets(0, left, 0, 5);
            c.gridwidth = 1;
            c.fill = 2;
            popup.add((Component)attachProject, c);
        }
        JLabel profileL = new JLabel(Bundle.ProfilerWindow_profileSection(), 10);
        profileL.setFont(popup.getFont().deriveFont(1));
        c = new GridBagConstraints();
        c.gridy = y++;
        c.insets = new Insets(_attach ? 8 : 5, labl, 5, 5);
        c.fill = 2;
        popup.add((Component)profileL, c);
        for (ToggleButtonMenuItem toggleButtonMenuItem : _items) {
            if (toggleButtonMenuItem == null) {
                JPanel p = new JPanel(null);
                p.setOpaque(false);
                c = new GridBagConstraints();
                c.gridy = y++;
                c.insets = new Insets(5, 0, 5, 0);
                c.fill = 2;
                popup.add((Component)p, c);
                continue;
            }
            c = new GridBagConstraints();
            c.gridy = y++;
            c.insets = new Insets(0, left, 0, 5);
            c.fill = 2;
            popup.add((Component)toggleButtonMenuItem, c);
        }
        JLabel settingsL = new JLabel(Bundle.ProfilerWindow_settingsSection(), 10);
        settingsL.setFont(popup.getFont().deriveFont(1));
        c = new GridBagConstraints();
        c.gridy = y++;
        c.insets = new Insets(8, labl, 5, 5);
        c.fill = 2;
        popup.add((Component)settingsL, c);
        c = new GridBagConstraints();
        c.gridy = y++;
        c.insets = new Insets(0, left, 0, 5);
        c.fill = 2;
        popup.add((Component)singleFeature, c);
        if (_project) {
            c = new GridBagConstraints();
            c.gridy = y++;
            c.insets = new Insets(0, left, 0, 5);
            c.fill = 2;
            popup.add((Component)usePPoints, c);
        }
        if (this.plugins.hasPlugins()) {
            JLabel jLabel = new JLabel(Bundle.ProfilerWindow_pluginsSection(), 10);
            jLabel.setFont(popup.getFont().deriveFont(1));
            c = new GridBagConstraints();
            c.gridy = y++;
            c.insets = new Insets(8, labl, 5, 5);
            c.fill = 2;
            popup.add((Component)jLabel, c);
            for (JMenuItem menu : this.plugins.menuItems()) {
                c = new GridBagConstraints();
                c.gridy = y++;
                c.insets = new Insets(0, left, 0, 5);
                c.fill = 2;
                popup.add((Component)menu, c);
            }
        }
        JPanel jPanel = new JPanel(null);
        jPanel.setOpaque(false);
        c = new GridBagConstraints();
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(3, 0, 0, 0);
        c.anchor = 18;
        c.fill = 1;
        popup.add((Component)jPanel, c);
        DropdownButton button = this.start.isVisible() ? this.start : this.configure;
        popup.show(button, 0, button.getHeight());
    }

    @Override
    protected Component defaultFocusOwner() {
        if (this.configure != null && this.configure.isVisible()) {
            return this.configure;
        }
        if (this.start != null) {
            return this.start;
        }
        return null;
    }

    public boolean canClose() {
        if (this.closing) {
            return true;
        }
        if (!super.canClose()) {
            return false;
        }
        this.closing = true;
        this.closing = this.session.close();
        return this.closing;
    }

    public void open() {
        Mode mode;
        WindowManager windowManager = WindowManager.getDefault();
        if (windowManager.findMode((TopComponent)this) == null && (mode = windowManager.findMode(Bundle.ProfilerWindow_mode())) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected void componentOpened() {
        super.componentOpened();
        SnapshotsWindow.instance().sessionOpened(this.session);
    }

    protected void componentShowing() {
        super.componentShowing();
        SnapshotsWindow.instance().sessionActivated(this.session);
    }

    protected void componentHidden() {
        super.componentHidden();
        SnapshotsWindow.instance().sessionDeactivated(this.session);
    }

    protected void componentClosed() {
        super.componentOpened();
        SnapshotsWindow.instance().sessionClosed(this.session);
    }

    @Override
    protected void componentActivated() {
        super.componentActivated();
        if (this.status != null) {
            this.status.startSessionLogging();
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return "ProfilerWindow";
    }

    public HelpCtx getHelpCtx() {
        String helpCtx;
        JPanel selectedUI;
        ProfilerFeature selected = this.featuresView == null ? null : this.featuresView.getSelectedFeature();
        JPanel jPanel = selectedUI = selected == null ? null : selected.getResultsUI();
        if (selectedUI == null && selected != null) {
            selectedUI = selected.getSettingsUI();
        }
        String string = helpCtx = selectedUI == null ? null : (String)selectedUI.getClientProperty("HelpCtx.Key");
        if (helpCtx == null) {
            helpCtx = "ProfileWindow.HelpCtx";
        }
        return new HelpCtx(helpCtx);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                @Override
                public String getAccessibleName() {
                    return Bundle.ProfilerWindow_accessName(ProfilerWindow.this.getDisplayName());
                }

                @Override
                public String getAccessibleDescription() {
                    ProfilerFeature selected = ProfilerWindow.this.featuresView == null ? null : ProfilerWindow.this.featuresView.getSelectedFeature();
                    return selected == null ? WelcomePanel.CAPTION : selected.getName() + " " + selected.getDescription();
                }
            };
        }
        return this.accessibleContext;
    }

    private static final class SettingsPresenter
    extends JToggleButton
    implements ComponentListener {
        private JPanel settings;

        SettingsPresenter() {
            super(Icons.getIcon((String)"GeneralIcons.Settings"));
            this.setToolTipText(Bundle.ProfilerWindow_settings());
            this.updateVisibility(false);
        }

        void setFeature(ProfilerFeature feature) {
            if (this.settings != null) {
                this.settings.removeComponentListener(this);
            }
            this.settings = feature == null ? null : feature.getSettingsUI();
            this.updateVisibility(false);
            if (this.settings != null) {
                this.settings.addComponentListener(this);
            }
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            if (this.settings != null) {
                this.settings.setVisible(this.isSelected());
                this.settings.getParent().setVisible(this.isSelected());
            }
        }

        void cleanup() {
            this.settings.removeComponentListener(this);
        }

        private void updateVisibility(boolean parent) {
            this.setVisible(this.settings != null);
            this.setSelected(this.settings != null && this.settings.isVisible());
            if (parent) {
                this.settings.getParent().setVisible(this.settings.isVisible());
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.updateVisibility(true);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.updateVisibility(true);
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }
    }
}

