/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ValidatorsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.Kerberos;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class KerberosProfile
extends ProfileBase
implements SecureConversationFeature,
ValidatorsFeature,
AdvancedSecurityFeature {
    @Override
    public int getId() {
        return 25;
    }

    @Override
    public String getDisplayName() {
        return ComboConstants.PROF_KERBEROS;
    }

    @Override
    public String getDescription() {
        return ComboConstants.PROF_KERBEROS_INFO;
    }

    @Override
    public boolean isProfileSupported(Project p, WSDLComponent component, boolean sts) {
        ConfigVersion configVersion = PolicyModelHelper.getConfigVersion(component);
        return !ConfigVersion.CONFIG_1_0.equals((Object)configVersion);
    }

    @Override
    public boolean isCurrentProfile(WSDLComponent component) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(component));
    }

    @Override
    public void displayConfig(WSDLComponent component, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel model = component.getModel();
        model.addUndoableEditListener((UndoableEditListener)undoCounter);
        Kerberos profConfigPanel = new Kerberos(component, this);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)profConfigPanel, this.getDisplayName());
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    @Override
    public boolean isSecureConversation(WSDLComponent component) {
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(component);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        return protToken instanceof SecureConversationToken;
    }

    @Override
    public void enableSecureConversation(WSDLComponent component, boolean enable) {
        ProfilesModelHelper pmh = ProfilesModelHelper.getInstance(PolicyModelHelper.getConfigVersion(component));
        pmh.setSecureConversation(component, enable);
    }

    @Override
    public boolean isValidatorSupported(ConfigVersion cfgVersion, String validatorType) {
        return !ConfigVersion.CONFIG_1_0.equals((Object)cfgVersion);
    }
}

