/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_POSIX;
import org.eclipse.jgit.util.FileUtil;
import org.eclipse.jgit.util.SystemReader;

public class FS_POSIX_Java7
extends FS_POSIX {
    private static final Boolean EXECUTE_FOR_OTHERS;
    private static final Boolean EXECUTE_FOR_GROUP;

    FS_POSIX_Java7(FS_POSIX_Java7 src) {
        super((FS)src);
    }

    FS_POSIX_Java7() {
    }

    public FS newInstance() {
        return new FS_POSIX_Java7(this);
    }

    public boolean supportsExecute() {
        return true;
    }

    public boolean canExecute(File f) {
        return FileUtil.canExecute(f);
    }

    public boolean setExecute(File f, boolean canExecute) {
        if (!this.isFile(f)) {
            return false;
        }
        if (canExecute && EXECUTE_FOR_OTHERS != null) {
            try {
                Path path = f.toPath();
                Set<PosixFilePermission> pset = Files.getPosixFilePermissions(path, new LinkOption[0]);
                pset.add(PosixFilePermission.OWNER_EXECUTE);
                if (EXECUTE_FOR_GROUP.booleanValue()) {
                    pset.add(PosixFilePermission.GROUP_EXECUTE);
                }
                if (EXECUTE_FOR_OTHERS.booleanValue()) {
                    pset.add(PosixFilePermission.OTHERS_EXECUTE);
                }
                Files.setPosixFilePermissions(path, pset);
                return true;
            }
            catch (IOException e) {
                boolean debug = Boolean.parseBoolean(SystemReader.getInstance().getProperty("jgit.fs.debug"));
                if (debug) {
                    System.err.println(e);
                }
                return false;
            }
        }
        return f.setExecutable(canExecute);
    }

    private static Boolean isGranted(PosixFilePermission p, String umask) {
        switch (p) {
            case OTHERS_EXECUTE: {
                char val = umask.charAt(umask.length() - 1);
                return FS_POSIX_Java7.isExecuteGranted(val);
            }
            case GROUP_EXECUTE: {
                char val = umask.charAt(umask.length() - 2);
                return FS_POSIX_Java7.isExecuteGranted(val);
            }
        }
        throw new UnsupportedOperationException("isGranted() for " + (Object)((Object)p) + " is not implemented!");
    }

    private static Boolean isExecuteGranted(char c) {
        if (c == '0' || c == '2' || c == '4' || c == '6') {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readUmask() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "umask"}, null, null);
            try (BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset().name()));){
                p.waitFor();
                String string = lineRead.readLine();
                return string;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean retryFailedLockFileCommit() {
        return false;
    }

    public boolean supportsSymlinks() {
        return true;
    }

    public boolean isSymLink(File path) throws IOException {
        return FileUtil.isSymlink(path);
    }

    public long lastModified(File path) throws IOException {
        return FileUtil.lastModified(path);
    }

    public void setLastModified(File path, long time) throws IOException {
        FileUtil.setLastModified(path, time);
    }

    public void delete(File path) throws IOException {
        FileUtil.delete(path);
    }

    public long length(File f) throws IOException {
        return FileUtil.getLength(f);
    }

    public boolean exists(File path) {
        return FileUtil.exists(path);
    }

    public boolean isDirectory(File path) {
        return FileUtil.isDirectory(path);
    }

    public boolean isFile(File path) {
        return FileUtil.isFile(path);
    }

    public boolean isHidden(File path) throws IOException {
        return FileUtil.isHidden(path);
    }

    public void setHidden(File path, boolean hidden) throws IOException {
    }

    public String readSymLink(File path) throws IOException {
        return FileUtil.readSymlink(path);
    }

    public void createSymLink(File path, String target) throws IOException {
        FileUtil.createSymLink(path, target);
    }

    public FS.Attributes getAttributes(File path) {
        return FileUtil.getFileAttributesPosix((FS)this, path);
    }

    public File normalize(File file) {
        return FileUtil.normalize(file);
    }

    public String normalize(String name) {
        return FileUtil.normalize(name);
    }

    static {
        String umask = FS_POSIX_Java7.readUmask();
        if (umask != null && umask.length() > 0 && umask.matches("\\d{3,4}")) {
            EXECUTE_FOR_OTHERS = FS_POSIX_Java7.isGranted(PosixFilePermission.OTHERS_EXECUTE, umask);
            EXECUTE_FOR_GROUP = FS_POSIX_Java7.isGranted(PosixFilePermission.GROUP_EXECUTE, umask);
        } else {
            EXECUTE_FOR_OTHERS = null;
            EXECUTE_FOR_GROUP = null;
        }
    }
}

