/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins;

import java.util.List;
import org.netbeans.modules.extbrowser.plugins.ExtensionManager;
import org.netbeans.modules.extbrowser.plugins.Utils;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;

public interface ExtensionManagerAccessor {
    public BrowserExtensionManager getManager();

    public static interface BrowserExtensionManager {
        public ExtensionManager.ExtensitionStatus isInstalled();

        public boolean install(ExtensionManager.ExtensitionStatus var1);

        public BrowserFamilyId getBrowserFamilyId();
    }

    public static abstract class AbstractBrowserExtensionManager
    implements BrowserExtensionManager {
        protected static final String PLUGIN_MODULE_NAME = "org.netbeans.modules.extbrowser.chrome";

        protected abstract String getCurrentPluginVersion();

        protected boolean isUpdateRequired(String extVersion) {
            String currentVersion = this.getCurrentPluginVersion();
            if (extVersion == null) {
                return true;
            }
            if (currentVersion == null) {
                return false;
            }
            List<Integer> extList = Utils.getVersionParts(extVersion);
            List<Integer> minList = Utils.getVersionParts(currentVersion);
            for (int i = 0; i < Math.max(extList.size(), minList.size()); ++i) {
                int minValue;
                int extValue = i >= extList.size() ? 0 : extList.get(i);
                int n = minValue = i >= minList.size() ? 0 : minList.get(i);
                if (extValue < minValue) {
                    return true;
                }
                if (extValue <= minValue) continue;
                return false;
            }
            return false;
        }
    }
}

