/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.io.BufferedInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jnlp.sample.servlet.DownloadRequest;
import jnlp.sample.servlet.DownloadResponse;
import jnlp.sample.servlet.ErrorResponseException;
import jnlp.sample.servlet.JnlpResource;
import jnlp.sample.servlet.Logger;
import jnlp.sample.servlet.XMLNode;
import jnlp.sample.servlet.XMLParsing;
import jnlp.sample.util.VersionID;
import jnlp.sample.util.VersionString;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class ResourceCatalog {
    public static final String VERSION_XML_FILENAME = "version.xml";
    private Logger _log = null;
    private ServletContext _servletContext = null;
    private HashMap _entries = new HashMap();

    public ResourceCatalog(ServletContext servletContext, Logger logger) {
        this._servletContext = servletContext;
        this._log = logger;
    }

    public JnlpResource lookupResource(DownloadRequest downloadRequest) throws ErrorResponseException {
        JnlpResource[] jnlpResourceArray;
        String string = downloadRequest.getPath();
        String string2 = null;
        String string3 = null;
        int n = string.lastIndexOf(47);
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(n + 1);
            string3 = string.substring(0, n + 1);
        }
        PathEntries pathEntries = (PathEntries)this._entries.get(string3);
        JnlpResource jnlpResource = new JnlpResource(this._servletContext, string3 + VERSION_XML_FILENAME);
        if (pathEntries == null || jnlpResource.exists() && jnlpResource.getLastModified() > pathEntries.getLastModified()) {
            this._log.addInformational("servlet.log.scandir", string3);
            jnlpResourceArray = this.scanDirectory(string3, downloadRequest);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.parseVersionXML(arrayList, arrayList2, string3, jnlpResource);
            pathEntries = new PathEntries(arrayList, (List)jnlpResourceArray, arrayList2, jnlpResource.getLastModified());
            this._entries.put(string3, pathEntries);
        }
        jnlpResourceArray = new JnlpResource[1];
        if (downloadRequest.isPlatformRequest()) {
            int n2 = this.findMatch(pathEntries.getPlatformList(), string2, downloadRequest, jnlpResourceArray);
            if (n2 != 0) {
                throw new ErrorResponseException(DownloadResponse.getJnlpErrorResponse(n2));
            }
        } else {
            int n3;
            int n4 = this.findMatch(pathEntries.getVersionXmlList(), string2, downloadRequest, jnlpResourceArray);
            if (n4 != 0 && (n3 = this.findMatch(pathEntries.getDirectoryList(), string2, downloadRequest, jnlpResourceArray)) != 0) {
                pathEntries.setDirectoryList(this.scanDirectory(string3, downloadRequest));
                n3 = this.findMatch(pathEntries.getDirectoryList(), string2, downloadRequest, jnlpResourceArray);
                if (n3 != 0) {
                    throw new ErrorResponseException(DownloadResponse.getJnlpErrorResponse(Math.max(n4, n3)));
                }
            }
        }
        return jnlpResourceArray[0];
    }

    public int findMatch(List list, String string, DownloadRequest downloadRequest, JnlpResource[] jnlpResourceArray) {
        if (list == null) {
            return 10;
        }
        VersionID versionID = null;
        int n = 10;
        VersionString versionString = new VersionString(downloadRequest.getVersion());
        for (int i = 0; i < list.size(); ++i) {
            VersionID versionID2;
            JnlpResource jnlpResource = (JnlpResource)list.get(i);
            int n2 = this.matchEntry(string, versionString, downloadRequest, jnlpResource, versionID2 = new VersionID(jnlpResource.getVersionId()));
            if (n2 == 0) {
                if (jnlpResourceArray[0] != null && !versionID2.isGreaterThan(versionID)) continue;
                jnlpResourceArray[0] = jnlpResource;
                versionID = versionID2;
                continue;
            }
            n = Math.max(n, n2);
        }
        return jnlpResourceArray[0] != null ? 0 : n;
    }

    public int matchEntry(String string, VersionString versionString, DownloadRequest downloadRequest, JnlpResource jnlpResource, VersionID versionID) {
        if (!string.equals(jnlpResource.getName())) {
            return 10;
        }
        if (!versionString.contains(versionID)) {
            return 11;
        }
        if (!this.prefixMatchLists(jnlpResource.getOSList(), downloadRequest.getOS())) {
            return 20;
        }
        if (!this.prefixMatchLists(jnlpResource.getArchList(), downloadRequest.getArch())) {
            return 21;
        }
        if (!this.prefixMatchLists(jnlpResource.getLocaleList(), downloadRequest.getLocale())) {
            return 22;
        }
        return 0;
    }

    private static boolean prefixMatchStringList(String[] stringArray, String string) {
        if (stringArray == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean prefixMatchLists(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return true;
        }
        if (stringArray2 == null) {
            return false;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!ResourceCatalog.prefixMatchStringList(stringArray, stringArray2[i])) continue;
            return true;
        }
        return false;
    }

    private String jnlpGetPath(DownloadRequest downloadRequest) {
        int n;
        String[] stringArray;
        String string = downloadRequest.getPath();
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        string = string.substring(0, string.lastIndexOf("/") + 1);
        String string3 = string2;
        String string4 = null;
        if (string2.lastIndexOf(".") != -1) {
            string4 = string2.substring(string2.lastIndexOf(".") + 1);
            string2 = string2.substring(0, string2.lastIndexOf("."));
        }
        if (downloadRequest.getVersion() != null) {
            string2 = string2 + "__V" + downloadRequest.getVersion();
        }
        if ((stringArray = downloadRequest.getOS()) != null) {
            for (n = 0; n < stringArray.length; ++n) {
                string2 = string2 + "__O" + stringArray[n];
            }
        }
        if ((stringArray = downloadRequest.getArch()) != null) {
            for (n = 0; n < stringArray.length; ++n) {
                string2 = string2 + "__A" + stringArray[n];
            }
        }
        if ((stringArray = downloadRequest.getLocale()) != null) {
            for (n = 0; n < stringArray.length; ++n) {
                string2 = string2 + "__L" + stringArray[n];
            }
        }
        if (string4 != null) {
            string2 = string2 + "." + string4;
        }
        string = string + string2;
        return string;
    }

    public List scanDirectory(String string, DownloadRequest downloadRequest) {
        ArrayList<JnlpResource> arrayList = new ArrayList<JnlpResource>();
        if (this._servletContext.getRealPath(string) == null) {
            String string2 = this.jnlpGetPath(downloadRequest);
            String string3 = downloadRequest.getPath().substring(string2.lastIndexOf("/") + 1);
            JnlpResource jnlpResource = new JnlpResource(this._servletContext, string3, downloadRequest.getVersion(), downloadRequest.getOS(), downloadRequest.getArch(), downloadRequest.getLocale(), string2, downloadRequest.getVersion());
            if (jnlpResource.getResource() == null) {
                return null;
            }
            arrayList.add(jnlpResource);
            return arrayList;
        }
        File file = new File(this._servletContext.getRealPath(string));
        this._log.addDebug("File directory: " + file);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                JnlpResource jnlpResource = this.parseFileEntry(string, fileArray[i].getName());
                if (jnlpResource == null) continue;
                if (this._log.isDebugLevel()) {
                    this._log.addDebug("Read file resource: " + jnlpResource);
                }
                arrayList.add(jnlpResource);
            }
        }
        return arrayList;
    }

    private JnlpResource parseFileEntry(String string, String string2) {
        int n = string2.indexOf("__");
        if (n == -1) {
            return null;
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n);
        n = string4.lastIndexOf(46);
        String string5 = "";
        if (n != -1) {
            string5 = string4.substring(n);
            string4 = string4.substring(0, n);
        }
        String string6 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        block6: while (string4.length() > 0) {
            if (!string4.startsWith("__")) {
                return null;
            }
            string4 = string4.substring(2);
            char c = string4.charAt(0);
            n = string4.indexOf("__");
            String string7 = null;
            if (n == -1) {
                string7 = string4.substring(1);
                string4 = "";
            } else {
                string7 = string4.substring(1, n);
                string4 = string4.substring(n);
            }
            switch (c) {
                case 'V': {
                    string6 = string7;
                    continue block6;
                }
                case 'O': {
                    arrayList.add(string7);
                    continue block6;
                }
                case 'A': {
                    arrayList2.add(string7);
                    continue block6;
                }
                case 'L': {
                    arrayList3.add(string7);
                    continue block6;
                }
            }
            return null;
        }
        return new JnlpResource(this._servletContext, string3 + string5, string6, this.listToStrings(arrayList), this.listToStrings(arrayList2), this.listToStrings(arrayList3), string + string2, string6);
    }

    private String[] listToStrings(List list) {
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private void parseVersionXML(final List list, final List list2, final String string, final JnlpResource jnlpResource) {
        if (!jnlpResource.exists()) {
            return;
        }
        XMLNode xMLNode = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new BufferedInputStream(jnlpResource.getResource().openStream()));
            document.getDocumentElement().normalize();
            xMLNode = XMLParsing.convert(document.getDocumentElement());
        }
        catch (SAXParseException sAXParseException) {
            this._log.addWarning("servlet.log.warning.xml.parsing", jnlpResource.getPath(), Integer.toString(sAXParseException.getLineNumber()), sAXParseException.getMessage());
            return;
        }
        catch (Throwable throwable) {
            this._log.addWarning("servlet.log.warning.xml.reading", jnlpResource.getPath(), throwable);
            return;
        }
        if (!xMLNode.getName().equals("jnlp-versions")) {
            this._log.addWarning("servlet.log.warning.xml.missing-jnlp", jnlpResource.getPath());
            return;
        }
        XMLParsing.visitElements(xMLNode, "<resource>", new XMLParsing.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) {
                XMLNode xMLNode2 = XMLParsing.findElementPath(xMLNode, "<pattern>");
                if (xMLNode2 == null) {
                    ResourceCatalog.this._log.addWarning("servlet.log.warning.xml.missing-pattern", jnlpResource.getPath());
                } else {
                    String string4 = XMLParsing.getElementContent(xMLNode2, "<name>", "");
                    String string2 = XMLParsing.getElementContent(xMLNode2, "<version-id>");
                    String[] stringArray = XMLParsing.getMultiElementContent(xMLNode2, "<os>");
                    String[] stringArray2 = XMLParsing.getMultiElementContent(xMLNode2, "<arch>");
                    String[] stringArray3 = XMLParsing.getMultiElementContent(xMLNode2, "<locale>");
                    String string3 = XMLParsing.getElementContent(xMLNode, "<file>");
                    if (string2 == null || string3 == null) {
                        ResourceCatalog.this._log.addWarning("servlet.log.warning.xml.missing-elems", jnlpResource.getPath());
                    } else {
                        JnlpResource jnlpResource2 = new JnlpResource(ResourceCatalog.this._servletContext, string4, string2, stringArray, stringArray2, stringArray3, string + string3, string2);
                        if (jnlpResource2.exists()) {
                            list.add(jnlpResource2);
                            if (ResourceCatalog.this._log.isDebugLevel()) {
                                ResourceCatalog.this._log.addDebug("Read resource: " + jnlpResource2);
                            }
                        } else {
                            ResourceCatalog.this._log.addWarning("servlet.log.warning.missing-file", string3, jnlpResource.getPath());
                        }
                    }
                }
            }
        });
        XMLParsing.visitElements(xMLNode, "<platform>", new XMLParsing.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) {
                XMLNode xMLNode2 = XMLParsing.findElementPath(xMLNode, "<pattern>");
                if (xMLNode2 == null) {
                    ResourceCatalog.this._log.addWarning("servlet.log.warning.xml.missing-pattern", jnlpResource.getPath());
                } else {
                    String string5 = XMLParsing.getElementContent(xMLNode2, "<name>", "");
                    String string2 = XMLParsing.getElementContent(xMLNode2, "<version-id>");
                    String[] stringArray = XMLParsing.getMultiElementContent(xMLNode2, "<os>");
                    String[] stringArray2 = XMLParsing.getMultiElementContent(xMLNode2, "<arch>");
                    String[] stringArray3 = XMLParsing.getMultiElementContent(xMLNode2, "<locale>");
                    String string3 = XMLParsing.getElementContent(xMLNode, "<file>");
                    String string4 = XMLParsing.getElementContent(xMLNode, "<product-version-id>");
                    if (string2 == null || string3 == null || string4 == null) {
                        ResourceCatalog.this._log.addWarning("servlet.log.warning.xml.missing-elems2", jnlpResource.getPath());
                    } else {
                        JnlpResource jnlpResource2 = new JnlpResource(ResourceCatalog.this._servletContext, string5, string2, stringArray, stringArray2, stringArray3, string + string3, string4);
                        if (jnlpResource2.exists()) {
                            list2.add(jnlpResource2);
                            if (ResourceCatalog.this._log.isDebugLevel()) {
                                ResourceCatalog.this._log.addDebug("Read platform resource: " + jnlpResource2);
                            }
                        } else {
                            ResourceCatalog.this._log.addWarning("servlet.log.warning.missing-file", string3, jnlpResource.getPath());
                        }
                    }
                }
            }
        });
    }

    private static class PathEntries {
        private List _versionXmlList;
        private List _directoryList;
        private List _platformList;
        private long _lastModified;

        public PathEntries(List list, List list2, List list3, long l) {
            this._versionXmlList = list;
            this._directoryList = list2;
            this._platformList = list3;
            this._lastModified = l;
        }

        public void setDirectoryList(List list) {
            this._directoryList = list;
        }

        public List getVersionXmlList() {
            return this._versionXmlList;
        }

        public List getDirectoryList() {
            return this._directoryList;
        }

        public List getPlatformList() {
            return this._platformList;
        }

        public long getLastModified() {
            return this._lastModified;
        }
    }
}

