/*
 * Decompiled with CFR 0.152.
 */
package info.dmtree;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public final class Uri {
    private static final String SEGMENT_LENGTH_LIMIT_PROPERTY = "org.osgi.impl.service.dmt.uri.limits.segmentlength";
    private static final int MINIMAL_SEGMENT_LENGTH_LIMIT = 32;
    private static final int segmentLengthLimit = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            String limitString = System.getProperty(Uri.SEGMENT_LENGTH_LIMIT_PROPERTY);
            int limit = 32;
            try {
                int limitInt = Integer.parseInt(limitString);
                if (limitInt >= 32) {
                    limit = limitInt;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new Integer(limit);
        }
    });
    private static final char[] BASE_64_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '_'};
    static /* synthetic */ Class array$B;

    private Uri() {
    }

    public static String mangle(String nodeName) {
        return Uri.mangle(nodeName, Uri.getMaxSegmentNameLength());
    }

    public static String toUri(String[] path) {
        if (0 == path.length) {
            return "";
        }
        if (path.length > Uri.getMaxUriSegments()) {
            throw new IllegalArgumentException("Path contains too many segments.");
        }
        StringBuffer uri = new StringBuffer();
        int uriLength = 0;
        for (int i = 0; i < path.length; ++i) {
            int segmentLength = Uri.getSegmentLength(path[i]);
            if (segmentLength > Uri.getMaxSegmentNameLength()) {
                throw new IllegalArgumentException("URI segment too long.");
            }
            if (i > 0) {
                uri.append('/');
                ++uriLength;
            }
            uriLength += segmentLength;
            uri.append(path[i]);
        }
        if (uriLength > Uri.getMaxUriLength()) {
            throw new IllegalArgumentException("URI too long.");
        }
        return ((Object)uri).toString();
    }

    private static int getSegmentLength(String segment) {
        if (segment.length() == 0) {
            throw new IllegalArgumentException("URI segment is empty.");
        }
        StringBuffer newsegment = new StringBuffer(segment);
        for (int i = 0; i < newsegment.length(); ++i) {
            if (newsegment.charAt(i) == '\\') {
                if (i == newsegment.length() - 1) {
                    throw new IllegalArgumentException("URI segment ends with the escape character.");
                }
                newsegment.deleteCharAt(i);
                continue;
            }
            if (newsegment.charAt(i) != '/') continue;
            throw new IllegalArgumentException("URI segment contains an unescaped '/' character.");
        }
        if (((Object)newsegment).toString().equals("..")) {
            throw new IllegalArgumentException("URI segment must not be \"..\".");
        }
        try {
            return ((Object)newsegment).toString().getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(((Object)e).toString());
        }
    }

    public static String[] toPath(String uri) {
        if (uri == null) {
            throw new NullPointerException("'uri' parameter is null.");
        }
        if (!Uri.isValidUri(uri)) {
            throw new IllegalArgumentException("Malformed URI: " + uri);
        }
        if (uri.length() == 0) {
            return new String[0];
        }
        ArrayList<String> segments = new ArrayList<String>();
        StringBuffer segment = new StringBuffer();
        boolean escape = false;
        for (int i = 0; i < uri.length(); ++i) {
            char ch = uri.charAt(i);
            if (escape) {
                if (ch == '/' || ch == '\\') {
                    segment.append('\\');
                }
                segment.append(ch);
                escape = false;
                continue;
            }
            if (ch == '/') {
                segments.add(((Object)segment).toString());
                segment = new StringBuffer();
                continue;
            }
            if (ch == '\\') {
                escape = true;
                continue;
            }
            segment.append(ch);
        }
        if (segment.length() > 0) {
            segments.add(((Object)segment).toString());
        }
        return segments.toArray(new String[segments.size()]);
    }

    public static int getMaxUriSegments() {
        return Integer.MAX_VALUE;
    }

    public static int getMaxUriLength() {
        return Integer.MAX_VALUE;
    }

    public static int getMaxSegmentNameLength() {
        return segmentLengthLimit;
    }

    public static boolean isAbsoluteUri(String uri) {
        if (null == uri) {
            throw new NullPointerException("'uri' parameter is null.");
        }
        if (!Uri.isValidUri(uri)) {
            throw new IllegalArgumentException("Malformed URI: " + uri);
        }
        return uri.equals(".") || uri.equals("\\.") || uri.startsWith("./") || uri.startsWith("\\./");
    }

    public static boolean isValidUri(String uri) {
        if (null == uri) {
            return false;
        }
        int paramLen = uri.length();
        if (paramLen == 0) {
            return true;
        }
        if (uri.charAt(0) == '/' || uri.charAt(paramLen - 1) == '\\') {
            return false;
        }
        int processedUriLength = 0;
        int segmentNumber = 0;
        uri = uri + '/';
        ++paramLen;
        int start = 0;
        for (int i = 1; i < paramLen; ++i) {
            int segmentLength;
            if (uri.charAt(i) != '/' || uri.charAt(i - 1) == '\\') continue;
            String segment = uri.substring(start, i);
            if (++segmentNumber > 1 && segment.equals(".")) {
                return false;
            }
            try {
                segmentLength = Uri.getSegmentLength(segment);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            if (segmentLength > Uri.getMaxSegmentNameLength()) {
                return false;
            }
            processedUriLength += segmentLength + 1;
            start = i + 1;
        }
        return segmentNumber <= Uri.getMaxUriSegments() && --processedUriLength <= Uri.getMaxUriLength();
    }

    static String mangle(String nodeName, int limit) {
        if (nodeName == null) {
            throw new NullPointerException("The 'nodeName' parameter must not be null.");
        }
        if (nodeName.equals("")) {
            throw new IllegalArgumentException("The 'nodeName' parameter must not be empty.");
        }
        if (nodeName.length() > limit) {
            return Uri.getHash(nodeName);
        }
        StringBuffer nameBuffer = new StringBuffer(nodeName);
        for (int i = 0; i < nameBuffer.length(); ++i) {
            if (nameBuffer.charAt(i) != '\\' && nameBuffer.charAt(i) != '/') continue;
            nameBuffer.insert(i++, '\\');
        }
        return ((Object)nameBuffer).toString();
    }

    private static String getHash(String from) {
        byte[] byteStream;
        try {
            byteStream = from.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("there's no UTF-8 encoder here!");
        }
        byte[] digest = Uri.digestMessage(byteStream);
        StringBuffer sb = new StringBuffer(digest.length * 2);
        for (int i = 0; i < 6; ++i) {
            int d0 = digest[i * 3] & 0xFF;
            int d1 = digest[i * 3 + 1] & 0xFF;
            int d2 = digest[i * 3 + 2] & 0xFF;
            sb.append(BASE_64_TABLE[d0 >> 2]);
            sb.append(BASE_64_TABLE[(d0 << 4 | d1 >> 4) & 0x3F]);
            sb.append(BASE_64_TABLE[(d1 << 2 | d2 >> 6) & 0x3F]);
            sb.append(BASE_64_TABLE[d2 & 0x3F]);
        }
        int d0 = digest[18] & 0xFF;
        int d1 = digest[19] & 0xFF;
        sb.append(BASE_64_TABLE[d0 >> 2]);
        sb.append(BASE_64_TABLE[(d0 << 4 | d1 >> 4) & 0x3F]);
        sb.append(BASE_64_TABLE[d1 << 2 & 0x3F]);
        return ((Object)sb).toString();
    }

    private static byte[] digestMessage(byte[] byteStream) {
        try {
            try {
                return (byte[])ImplHolder.digestMethod.invoke(null, new Object[]{byteStream});
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(((Object)e).toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ImplHolder
    implements PrivilegedAction {
        private static final String DIGEST_DELEGATE_PROPERTY = "org.osgi.vendor.dmtree.DigestDelegate";
        static final Method digestMethod = (Method)AccessController.doPrivileged(new ImplHolder());

        private ImplHolder() {
        }

        public Object run() {
            Method result;
            Class<?> delegateClass;
            String className = System.getProperty(DIGEST_DELEGATE_PROPERTY);
            if (className == null) {
                throw new NoClassDefFoundError("Digest delegate class property 'org.osgi.vendor.dmtree.DigestDelegate' must be set to a class which implements a public static byte[] digest(byte[]) method.");
            }
            try {
                delegateClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(((Object)e).toString());
            }
            try {
                result = delegateClass.getMethod("digest", array$B == null ? (array$B = Uri.class$("[B")) : array$B);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(((Object)e).toString());
            }
            if (!Modifier.isStatic(result.getModifiers())) {
                throw new NoSuchMethodError("digest method must be static");
            }
            return result;
        }
    }
}

