/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.optional;

import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.deployment.plugins.spi.FindJSPServlet2;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;

public class WLFindJSPServlet
implements FindJSPServlet2 {
    private static final Logger LOGGER = Logger.getLogger(WLFindJSPServlet.class.getName());
    private final WLDeploymentManager deploymentManager;

    public WLFindJSPServlet(WLDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public File getServletTempDirectory(String moduleContextPath) {
        File[] subDirs;
        ApplicationDescriptor desc = this.getApplicationDescriptor(moduleContextPath);
        if (desc == null) {
            return null;
        }
        String domainDir = this.deploymentManager.getInstanceProperties().getProperty("domainRoot");
        assert (domainDir != null);
        File tmpPath = new File(new File(domainDir), "servers" + File.separator + desc.getServerName() + File.separator + "tmp" + File.separator + "_WL_user" + File.separator + desc.getName());
        if (tmpPath.exists() && tmpPath.isDirectory() && (subDirs = tmpPath.listFiles()) != null) {
            for (File subdir : subDirs) {
                File servletDir = new File(subdir, "jsp_servlet");
                if (!servletDir.exists() || !servletDir.isDirectory()) continue;
                return servletDir.getParentFile();
            }
        }
        return null;
    }

    public String getServletResourcePath(String moduleContextPath, String jspResourcePath) {
        String fixedJspResourcePath = jspResourcePath.startsWith("/") ? jspResourcePath.substring(1) : jspResourcePath;
        String[] parts = fixedJspResourcePath.split("/");
        String jspFile = parts[parts.length - 1];
        StringBuilder result = new StringBuilder("jsp_servlet/");
        for (int i = 0; i < parts.length - 1; ++i) {
            result.append("_").append(parts[i]).append("/");
        }
        result.append("__");
        int dotIndex = jspFile.lastIndexOf(46);
        if (dotIndex < 0) {
            result.append(jspFile).append(".java");
        } else {
            result.append(jspFile.substring(0, dotIndex)).append(".java");
        }
        return result.toString();
    }

    public String getServletBasePackageName(String moduleContextPath) {
        return "jsp_servlet";
    }

    public String getServletSourcePath(String moduleContextPath, String jspRelativePath) {
        StringBuilder builder = new StringBuilder("jsp_servlet/");
        String[] parts = jspRelativePath.split("/");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.length() > 0 && i < parts.length - 1) {
                builder.append("_");
            }
            builder.append(part);
            if (i >= parts.length - 1) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    public String getServletEncoding(String moduleContextPath, String jspResourcePath) {
        return "UTF8";
    }

    private ApplicationDescriptor getApplicationDescriptor(final String moduleContextPath) {
        WLConnectionSupport support = this.deploymentManager.getConnectionSupport();
        try {
            return support.executeAction(new WLConnectionSupport.JMXRuntimeAction<ApplicationDescriptor>(){

                @Override
                public ApplicationDescriptor call(MBeanServerConnection con, ObjectName service) throws Exception {
                    ObjectName pattern = new ObjectName("com.bea:Type=WebAppComponentRuntime,*");
                    Set<ObjectName> runtimes = con.queryNames(pattern, null);
                    for (ObjectName runtime : runtimes) {
                        ObjectName application;
                        String contextRoot = (String)con.getAttribute(runtime, "ContextRoot");
                        if (!moduleContextPath.equals(contextRoot) || (application = (ObjectName)con.getAttribute(runtime, "Parent")) == null) continue;
                        String name = (String)con.getAttribute(application, "ApplicationName");
                        ObjectName server = (ObjectName)con.getAttribute(application, "Parent");
                        if (server == null) continue;
                        String serverName = (String)con.getAttribute(server, "Name");
                        return new ApplicationDescriptor(name, serverName);
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    private static class ApplicationDescriptor {
        private final String name;
        private final String serverName;

        public ApplicationDescriptor(String name, String serverName) {
            this.name = name;
            this.serverName = serverName;
        }

        public String getName() {
            return this.name;
        }

        public String getServerName() {
            return this.serverName;
        }
    }
}

