/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.ExpressionStatement;
import com.oracle.js.parser.ir.ForNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.IfNode;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.ReturnNode;
import com.oracle.js.parser.ir.ThrowNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.WhileNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.javascript2.editor.embedding.JsEmbeddingProvider;
import org.netbeans.modules.javascript2.editor.hints.ArrayTrailingComma;
import org.netbeans.modules.javascript2.editor.hints.AssignmentInCondition;
import org.netbeans.modules.javascript2.editor.hints.BetterConditionHint;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.DuplicatePropertyName;
import org.netbeans.modules.javascript2.editor.hints.JsAstRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.javascript2.editor.hints.MissingSemicolonHint;
import org.netbeans.modules.javascript2.editor.hints.ObjectTrailingComma;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.spi.PathNodeVisitor;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;

public class JsConventionRule
extends JsAstRule {
    private static final List<JsTokenId> IGNORED = new ArrayList<JsTokenId>();

    @Override
    void computeHints(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, HintsProvider.HintsManager manager) {
        Map allHints = manager.getHints();
        List conventionHints = (List)allHints.get("jsconvention.option.hints");
        Rule.AstRule betterConditionRule = null;
        Rule.AstRule missingSemicolon = null;
        Rule.AstRule duplicatePropertyName = null;
        Rule.AstRule assignmentInCondition = null;
        Rule.AstRule objectTrailingComma = null;
        Rule.AstRule arrayTrailingComma = null;
        if (conventionHints != null) {
            for (Rule.AstRule astRule : conventionHints) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                if (astRule instanceof BetterConditionHint) {
                    betterConditionRule = astRule;
                    continue;
                }
                if (astRule instanceof MissingSemicolonHint) {
                    missingSemicolon = astRule;
                    continue;
                }
                if (astRule instanceof DuplicatePropertyName) {
                    duplicatePropertyName = astRule;
                    continue;
                }
                if (astRule instanceof AssignmentInCondition) {
                    assignmentInCondition = astRule;
                    continue;
                }
                if (astRule instanceof ObjectTrailingComma) {
                    objectTrailingComma = astRule;
                    continue;
                }
                if (!(astRule instanceof ArrayTrailingComma)) continue;
                arrayTrailingComma = astRule;
            }
        }
        ConventionVisitor conventionVisitor = new ConventionVisitor((Rule)betterConditionRule, (Rule)missingSemicolon, (Rule)duplicatePropertyName, (Rule)assignmentInCondition, (Rule)objectTrailingComma, (Rule)arrayTrailingComma);
        conventionVisitor.process(context, hints);
    }

    public Set<?> getKinds() {
        return Collections.singleton("js.other.hints");
    }

    public String getId() {
        return "jsconvention.hint";
    }

    public String getDescription() {
        return Bundle.JsConventionHintDesc();
    }

    public String getDisplayName() {
        return Bundle.JsConventionHintDisplayName();
    }

    static {
        Collections.addAll(IGNORED, JsTokenId.BLOCK_COMMENT, JsTokenId.DOC_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.WHITESPACE, JsTokenId.EOL);
    }

    private static class ConventionVisitor
    extends PathNodeVisitor {
        private final Rule betterConditionRule;
        private final Rule missingSemicolon;
        private final Rule duplicatePropertyName;
        private final Rule assignmentInCondition;
        private final Rule objectTrailingComma;
        private final Rule arrayTrailingComma;
        private List<Hint> hints;
        private JsHintsProvider.JsRuleContext context;

        public ConventionVisitor(Rule betterCondition, Rule missingSemicolon, Rule duplicatePropertyName, Rule assignmentInCondition, Rule objectTrailingComma, Rule arrayTrailingComma) {
            this.betterConditionRule = betterCondition;
            this.missingSemicolon = missingSemicolon;
            this.duplicatePropertyName = duplicatePropertyName;
            this.assignmentInCondition = assignmentInCondition;
            this.objectTrailingComma = objectTrailingComma;
            this.arrayTrailingComma = arrayTrailingComma;
        }

        public void process(JsHintsProvider.JsRuleContext context, List<Hint> hints) {
            this.hints = hints;
            this.context = context;
            FunctionNode root = context.getJsParserResult().getRoot();
            if (root != null) {
                context.getJsParserResult().getRoot().accept((NodeVisitor)this);
            }
        }

        private void checkSemicolon(int offset) {
            if (this.missingSemicolon == null) {
                return;
            }
            int fileOffset = this.context.parserResult.getSnapshot().getOriginalOffset(offset);
            if (fileOffset == -1) {
                return;
            }
            TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)this.context.parserResult.getSnapshot(), (int)offset);
            if (ts == null) {
                return;
            }
            ts.move(offset - 1);
            if (ts.moveNext() && ts.token().id() == JsTokenId.OPERATOR_SEMICOLON) {
                return;
            }
            ts.move(offset);
            if (ts.movePrevious() && ts.moveNext()) {
                Token previous;
                int position;
                JsTokenId id = (JsTokenId)ts.token().id();
                if (id == JsTokenId.ERROR) {
                    return;
                }
                if ((id == JsTokenId.STRING_END || id == JsTokenId.TEMPLATE_END) && ts.moveNext()) {
                    id = (JsTokenId)ts.token().id();
                }
                if (id == JsTokenId.EOL) {
                    position = ts.offset();
                    Token next = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT));
                    id = (JsTokenId)next.id();
                    if (id != JsTokenId.OPERATOR_SEMICOLON && id != JsTokenId.OPERATOR_COMMA && ts.movePrevious()) {
                        ts.move(position);
                        ts.moveNext();
                        id = (JsTokenId)ts.token().id();
                    }
                }
                if ((id == JsTokenId.EOL || id == JsTokenId.BRACKET_RIGHT_CURLY) && ts.movePrevious()) {
                    id = (JsTokenId)ts.token().id();
                }
                if (id == JsTokenId.BLOCK_COMMENT || id == JsTokenId.DOC_COMMENT || id == JsTokenId.LINE_COMMENT || id == JsTokenId.WHITESPACE) {
                    position = ts.offset();
                    Token prev = LexUtilities.findPrevious((TokenSequence)ts, (List)IGNORED);
                    if (prev != null && (prev.id() == JsTokenId.OPERATOR_SEMICOLON || prev.id() == JsTokenId.OPERATOR_COMMA)) {
                        id = (JsTokenId)prev.id();
                    } else {
                        ts.move(position);
                        ts.moveNext();
                        Token next = LexUtilities.findNext((TokenSequence)ts, (List)IGNORED);
                        id = (JsTokenId)next.id();
                        if (id == JsTokenId.IDENTIFIER || id == JsTokenId.BRACKET_RIGHT_CURLY) {
                            ts.movePrevious();
                        }
                    }
                }
                if (id != JsTokenId.OPERATOR_SEMICOLON && id != JsTokenId.OPERATOR_COMMA && (id = (JsTokenId)(previous = LexUtilities.findPrevious((TokenSequence)ts, (List)IGNORED)).id()) != JsTokenId.OPERATOR_SEMICOLON && id != JsTokenId.OPERATOR_COMMA && !JsEmbeddingProvider.isGeneratedIdentifier(previous.text().toString()) && (fileOffset = this.context.parserResult.getSnapshot().getOriginalOffset(ts.offset())) >= 0) {
                    this.addMissingSemicolonHint(fileOffset, ts.token().text().toString());
                }
            } else if (!ts.moveNext() && ts.movePrevious() && ts.moveNext()) {
                int originalOffset = ts.offset();
                CharSequence originalText = ts.token().text();
                Token previous = LexUtilities.findPrevious((TokenSequence)ts, (List)IGNORED);
                if (previous != null && previous.id() == JsTokenId.OPERATOR_SEMICOLON) {
                    return;
                }
                fileOffset = this.context.parserResult.getSnapshot().getOriginalOffset(originalOffset);
                this.addMissingSemicolonHint(fileOffset, originalText.toString());
            }
        }

        private void addMissingSemicolonHint(int offset, String problemText) {
            String correctedText = problemText;
            int index = correctedText.indexOf(10);
            if (index == 0) {
                index = correctedText.indexOf(10, 1);
            }
            if (index > 0) {
                correctedText = correctedText.substring(0, index);
            }
            this.hints.add(new Hint(this.missingSemicolon, Bundle.MissingSemicolon(correctedText), this.context.getJsParserResult().getSnapshot().getSource().getFileObject(), new OffsetRange(offset, offset + correctedText.length()), null, 500));
        }

        private void checkAssignmentInCondition(Node condition) {
            if (this.assignmentInCondition == null) {
                return;
            }
            if (condition instanceof BinaryNode) {
                BinaryNode binaryNode = (BinaryNode)condition;
                if (binaryNode.isAssignment()) {
                    TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)this.context.parserResult.getSnapshot(), (int)condition.getStart());
                    if (ts == null) {
                        return;
                    }
                    ts.move(condition.getStart());
                    int parenBalance = 0;
                    if (ts.moveNext()) {
                        JsTokenId id = (JsTokenId)ts.token().id();
                        while (id != JsTokenId.KEYWORD_IF && id != JsTokenId.KEYWORD_FOR && id != JsTokenId.KEYWORD_WHILE && ts.movePrevious()) {
                            id = (JsTokenId)ts.token().id();
                            if (id == JsTokenId.BRACKET_RIGHT_PAREN) {
                                --parenBalance;
                                continue;
                            }
                            if (id != JsTokenId.BRACKET_LEFT_PAREN) continue;
                            ++parenBalance;
                        }
                    }
                    if (parenBalance == 1) {
                        this.hints.add(new Hint(this.assignmentInCondition, Bundle.AssignmentCondition(), this.context.getJsParserResult().getSnapshot().getSource().getFileObject(), ModelUtils.documentOffsetRange((ParserResult)this.context.getJsParserResult(), (int)condition.getStart(), (int)condition.getFinish()), null, 500));
                    }
                }
                if (binaryNode.lhs() instanceof BinaryNode) {
                    this.checkAssignmentInCondition((Node)binaryNode.lhs());
                }
                if (binaryNode.rhs() instanceof BinaryNode) {
                    this.checkAssignmentInCondition((Node)binaryNode.rhs());
                }
            }
        }

        private void checkCondition(BinaryNode binaryNode) {
            if (this.betterConditionRule == null) {
                return;
            }
            String message = null;
            switch (binaryNode.tokenType()) {
                case EQ: {
                    message = Bundle.ExpectedInstead("===", "==");
                    break;
                }
                case NE: {
                    message = Bundle.ExpectedInstead("!==", "!=");
                    break;
                }
            }
            if (message != null) {
                this.hints.add(new Hint(this.betterConditionRule, message, this.context.getJsParserResult().getSnapshot().getSource().getFileObject(), ModelUtils.documentOffsetRange((ParserResult)this.context.getJsParserResult(), (int)binaryNode.getStart(), (int)binaryNode.getFinish()), null, 500));
            }
        }

        private void checkDuplicateLabels(ObjectNode objectNode) {
            if (this.duplicatePropertyName == null) {
                return;
            }
            int startOffset = this.context.parserResult.getSnapshot().getOriginalOffset(objectNode.getStart());
            int endOffset = this.context.parserResult.getSnapshot().getOriginalOffset(objectNode.getFinish());
            if (startOffset == -1 || endOffset == -1) {
                return;
            }
            TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)this.context.parserResult.getSnapshot(), (int)objectNode.getStart());
            if (ts == null) {
                return;
            }
            ts.move(objectNode.getStart());
            State state = State.BEFORE_COLON;
            int curlyBalance = 0;
            int parenBalance = 0;
            int bracketBalance = 0;
            boolean isGetterSetter = false;
            if (ts.movePrevious() && ts.moveNext()) {
                HashSet<String> names = new HashSet<String>();
                block7: while (ts.moveNext() && ts.offset() < objectNode.getFinish()) {
                    JsTokenId id = (JsTokenId)ts.token().id();
                    switch (state) {
                        case BEFORE_COLON: {
                            if (id == JsTokenId.IDENTIFIER || id == JsTokenId.STRING) {
                                int docOffset;
                                String name = ts.token().text().toString();
                                if (this.context.getJsParserResult().isEmbedded() && JsEmbeddingProvider.isGeneratedIdentifier(name)) continue block7;
                                if ("set".equals(name) || "get".equals(name)) {
                                    isGetterSetter = true;
                                    break;
                                }
                                if (names.add(name) || isGetterSetter || (docOffset = this.context.parserResult.getSnapshot().getOriginalOffset(ts.offset())) < 0) continue block7;
                                this.hints.add(new Hint(this.duplicatePropertyName, Bundle.DuplicateName(name), this.context.getJsParserResult().getSnapshot().getSource().getFileObject(), new OffsetRange(docOffset, docOffset + ts.token().length()), null, 500));
                                break;
                            }
                            if (id == JsTokenId.OPERATOR_COLON) {
                                state = State.AFTER_COLON;
                                break;
                            }
                            if (id != JsTokenId.BRACKET_LEFT_CURLY) break;
                            state = State.AFTER_CURLY;
                            isGetterSetter = false;
                            break;
                        }
                        case AFTER_COLON: {
                            if (id == JsTokenId.OPERATOR_COMMA) {
                                state = State.BEFORE_COLON;
                                break;
                            }
                            if (id == JsTokenId.BRACKET_LEFT_CURLY) {
                                state = State.AFTER_CURLY;
                                break;
                            }
                            if (id == JsTokenId.BRACKET_LEFT_PAREN) {
                                state = State.AFTER_PAREN;
                                break;
                            }
                            if (id != JsTokenId.BRACKET_LEFT_BRACKET) break;
                            state = State.AFTER_BRACKET;
                            break;
                        }
                        case AFTER_CURLY: {
                            if (id == JsTokenId.BRACKET_LEFT_CURLY) {
                                ++curlyBalance;
                                break;
                            }
                            if (id != JsTokenId.BRACKET_RIGHT_CURLY) break;
                            if (curlyBalance == 0) {
                                state = State.AFTER_COLON;
                                break;
                            }
                            --curlyBalance;
                            break;
                        }
                        case AFTER_PAREN: {
                            if (id == JsTokenId.BRACKET_LEFT_PAREN) {
                                ++parenBalance;
                                break;
                            }
                            if (id != JsTokenId.BRACKET_RIGHT_PAREN) break;
                            if (parenBalance == 0) {
                                state = State.AFTER_COLON;
                                break;
                            }
                            --parenBalance;
                            break;
                        }
                        case AFTER_BRACKET: {
                            if (id == JsTokenId.BRACKET_LEFT_BRACKET) {
                                ++bracketBalance;
                                break;
                            }
                            if (id != JsTokenId.BRACKET_RIGHT_BRACKET) break;
                            if (bracketBalance == 0) {
                                state = State.AFTER_COLON;
                                break;
                            }
                            --bracketBalance;
                        }
                    }
                }
            }
        }

        public boolean enterForNode(ForNode forNode) {
            if (forNode.getTest() != null) {
                this.checkAssignmentInCondition((Node)forNode.getTest().getExpression());
            }
            return super.enterForNode(forNode);
        }

        public boolean enterIfNode(IfNode ifNode) {
            this.checkAssignmentInCondition((Node)ifNode.getTest());
            return super.enterIfNode(ifNode);
        }

        public boolean enterWhileNode(WhileNode whileNode) {
            this.checkAssignmentInCondition((Node)whileNode.getTest().getExpression());
            return super.enterWhileNode(whileNode);
        }

        public boolean enterExpressionStatement(ExpressionStatement expressionStatement) {
            Block block = this.getLexicalContext().getCurrentBlock();
            if (block == null || !block.isParameterBlock()) {
                this.checkSemicolon(expressionStatement.getFinish());
            }
            return super.enterExpressionStatement(expressionStatement);
        }

        public boolean enterThrowNode(ThrowNode throwNode) {
            this.checkSemicolon(throwNode.getExpression().getFinish());
            return super.enterThrowNode(throwNode);
        }

        public boolean enterObjectNode(ObjectNode objectNode) {
            int offset;
            this.checkDuplicateLabels(objectNode);
            if (this.objectTrailingComma != null && (offset = this.context.parserResult.getSnapshot().getOriginalOffset(objectNode.getFinish())) > -1) {
                TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)this.context.parserResult.getSnapshot(), (int)objectNode.getFinish());
                if (ts == null) {
                    return super.enterObjectNode(objectNode);
                }
                ts.move(objectNode.getFinish());
                if (ts.movePrevious() && ts.moveNext() && ts.movePrevious()) {
                    LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.EOL, JsTokenId.WHITESPACE, JsTokenId.BRACKET_RIGHT_CURLY, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT, JsTokenId.DOC_COMMENT));
                    if (ts.token().id() == JsTokenId.OPERATOR_COMMA && (offset = this.context.parserResult.getSnapshot().getOriginalOffset(ts.offset())) >= 0) {
                        this.hints.add(new Hint(this.objectTrailingComma, Bundle.UnexpectedObjectTrailing(ts.token().text().toString()), this.context.getJsParserResult().getSnapshot().getSource().getFileObject(), new OffsetRange(offset, offset + ts.token().length()), null, 500));
                    }
                }
            }
            return super.enterObjectNode(objectNode);
        }

        public boolean enterLiteralNode(LiteralNode literalNode) {
            if (this.arrayTrailingComma != null && literalNode.getValue() instanceof Node[]) {
                Node previous = (Node)this.getPath().get(this.getPath().size() - 1);
                if (previous instanceof BinaryNode && ((BinaryNode)previous).lhs() == literalNode) {
                    return super.enterLiteralNode(literalNode);
                }
                int offset = this.context.parserResult.getSnapshot().getOriginalOffset(literalNode.getFinish());
                if (offset > -1) {
                    TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)this.context.parserResult.getSnapshot(), (int)literalNode.getFinish());
                    if (ts == null) {
                        return super.enterLiteralNode(literalNode);
                    }
                    ts.move(literalNode.getFinish());
                    if (ts.movePrevious() && ts.moveNext() && ts.movePrevious()) {
                        LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.EOL, JsTokenId.WHITESPACE, JsTokenId.BRACKET_RIGHT_BRACKET, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT, JsTokenId.DOC_COMMENT));
                        if (ts.token().id() == JsTokenId.OPERATOR_COMMA && (offset = this.context.parserResult.getSnapshot().getOriginalOffset(ts.offset())) >= 0) {
                            this.hints.add(new Hint(this.arrayTrailingComma, Bundle.UnexpectedArrayTrailing(ts.token().text().toString()), this.context.getJsParserResult().getSnapshot().getSource().getFileObject(), new OffsetRange(offset, offset + ts.token().length()), null, 500));
                        }
                    }
                }
            }
            return super.enterLiteralNode(literalNode);
        }

        public boolean enterVarNode(VarNode varNode) {
            boolean check = true;
            Node previous = (Node)this.getPath().get(this.getPath().size() - 1);
            if (previous instanceof Block) {
                Block block = (Block)previous;
                if (block.getStatements().size() == 2 && block.getStatements().get(1) instanceof ForNode) {
                    check = false;
                }
            } else if (previous instanceof ForNode) {
                check = false;
            }
            if (varNode.isFunctionDeclaration() || varNode.isExport() || varNode.isDestructuring()) {
                check = false;
            }
            if (varNode.getInit() instanceof ClassNode) {
                IdentNode cIdent = ((ClassNode)varNode.getInit()).getIdent();
                IdentNode vIdent = varNode.getName();
                if (cIdent != null && cIdent.getStart() == vIdent.getStart() && cIdent.getFinish() == vIdent.getFinish()) {
                    check = false;
                }
            }
            if (check) {
                this.checkSemicolon(varNode.getFinish());
            }
            return super.enterVarNode(varNode);
        }

        public boolean enterReturnNode(ReturnNode returnNode) {
            FunctionNode function = this.getLexicalContext().getCurrentFunction();
            if (function == null || function.getKind() != FunctionNode.Kind.ARROW || com.oracle.js.parser.Token.descType((long)function.getBody().getToken()) == TokenType.LBRACE) {
                this.checkSemicolon(returnNode.getFinish());
            }
            return super.enterReturnNode(returnNode);
        }

        public boolean enterBinaryNode(BinaryNode binaryNode) {
            this.checkCondition(binaryNode);
            return super.enterBinaryNode(binaryNode);
        }

        private static enum State {
            BEFORE_COLON,
            AFTER_COLON,
            AFTER_CURLY,
            AFTER_PAREN,
            AFTER_BRACKET;

        }
    }
}

