/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;

public class LastTargetExecuted
implements BuildExecutionSupport.ActionItem {
    private File buildScript;
    private String[] targets;
    private Map<String, String> properties;
    private String displayName;
    private Thread thread;
    private static final ChangeSupport cs = new ChangeSupport(LastTargetExecuted.class);

    private LastTargetExecuted() {
    }

    static LastTargetExecuted record(File buildScript, String[] targets, Map<String, String> properties, String displayName, Thread thread) {
        LastTargetExecuted rec = new LastTargetExecuted();
        rec.buildScript = buildScript;
        rec.targets = targets;
        rec.properties = properties;
        rec.displayName = displayName;
        rec.thread = thread;
        BuildExecutionSupport.registerRunningItem((BuildExecutionSupport.Item)rec);
        return rec;
    }

    static void finish(LastTargetExecuted exc) {
        BuildExecutionSupport.registerFinishedItem((BuildExecutionSupport.Item)exc);
    }

    public static AntProjectCookie getLastBuildScript(LastTargetExecuted ext) {
        if (ext.buildScript != null && ext.buildScript.isFile()) {
            FileObject fo = FileUtil.toFileObject((File)ext.buildScript);
            assert (fo != null);
            return AntScriptUtils.antProjectCookieFor(fo);
        }
        return null;
    }

    public static ExecutorTask rerun(LastTargetExecuted exec) throws IOException {
        AntProjectCookie apc = LastTargetExecuted.getLastBuildScript(exec);
        if (apc == null) {
            cs.fireChange();
            return null;
        }
        TargetExecutor t = new TargetExecutor(apc, exec.targets);
        t.setProperties(exec.properties);
        t.setDisplayName(exec.displayName);
        return t.execute();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void repeatExecution() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    LastTargetExecuted.rerun(LastTargetExecuted.this);
                }
                catch (IOException ioe) {
                    AntModule.err.notify((Throwable)ioe);
                }
            }
        });
    }

    public boolean isRunning() {
        return this.thread != null ? this.thread.isAlive() : false;
    }

    public void stopRunning() {
        if (this.thread != null) {
            AntBridge.getInterface().stop(this.thread);
        }
    }

    public String getAction() {
        String p = this.properties != null ? this.properties.get("nb.internal.action.name") : null;
        return p != null ? p : "xxx-custom";
    }

    public FileObject getProjectDirectory() {
        String wd = this.properties.get("work.dir");
        if (wd != null) {
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(wd)));
        }
        return FileUtil.toFileObject((File)this.buildScript.getParentFile());
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.buildScript != null ? this.buildScript.hashCode() : 0);
        hash = 71 * hash + Arrays.deepHashCode(this.targets);
        hash = 71 * hash + this.getAction().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LastTargetExecuted other = (LastTargetExecuted)obj;
        if (!(this.properties.get("work.dir") != null && this.properties.get("work.dir").equals(other.properties.get("work.dir")) || this.buildScript.getParentFile().getAbsolutePath().equals(other.buildScript.getParentFile().getAbsolutePath()) || this.buildScript.getParentFile().getAbsolutePath().equals(other.properties.get("work.dir")) || other.buildScript.getParentFile().getAbsolutePath().equals(this.properties.get("work.dir")))) {
            return false;
        }
        return this.getAction().equals(other.getAction());
    }
}

