/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;

class FSSUtil {
    private FSSUtil() {
    }

    public static IOException createIOException(int errno, String emsg, ExecutionEnvironment execEnv) {
        switch (errno) {
            case 2: 
            case 13: {
                return RemoteExceptions.annotateException(new FSSFileNotFoundException(errno, emsg));
            }
            case 0: {
                RemoteLogger.info("fs_server [{0}] reports zero errno; treating as 'file not found': {1}", execEnv, emsg);
                return RemoteExceptions.annotateException(new FSSFileNotFoundException(errno, emsg));
            }
        }
        return RemoteExceptions.annotateException(new FSSIOException(errno, emsg));
    }

    public static String unescape(String line) {
        if (line.indexOf(92) == -1) {
            return line;
        }
        return line.replace("\\n", "\n").replace("\\\\", "\\");
    }

    public static String escape(String line) {
        if (line.indexOf(10) == -1 && line.indexOf(92) == -1) {
            return line;
        }
        return line.replace("\n", "\\n").replace("\\", "\\\\");
    }

    public static final class FSSGenericException
    extends Exception
    implements FSSException {
        private final int errno;

        private FSSGenericException(int errno, String message) {
            super(message);
            this.errno = errno;
        }

        @Override
        public int getErrno() {
            return this.errno;
        }
    }

    public static final class FSSFileNotFoundException
    extends FileNotFoundException
    implements FSSException {
        private final int errno;

        private FSSFileNotFoundException(int errno, String message) {
            super(message);
            this.errno = errno;
        }

        @Override
        public int getErrno() {
            return this.errno;
        }
    }

    public static final class FSSIOException
    extends IOException
    implements FSSException {
        private final int errno;

        private FSSIOException(int errno, String message) {
            super(message);
            this.errno = errno;
        }

        @Override
        public int getErrno() {
            return this.errno;
        }
    }

    public static interface FSSException {
        public int getErrno();
    }
}

