/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.netbeans.modules.cnd.makefile.wizard.CompilerFlags;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makefile.wizard.OptionSource;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;

public class BasicFlagsPanel
extends MakefileWizardPanel {
    static final long serialVersionUID = -2105207605584107631L;
    private JRadioButton develBuildRB;
    private JRadioButton develDebugCodeRB;
    private JRadioButton develOptDebugCodeRB;
    private JRadioButton finalBuildRB;
    private JCheckBox finalOptTB;
    private JCheckBox finalStripTB;
    private JCheckBox create64BitTB;
    private JCheckBox moduleSupportTB;
    private boolean initialized;

    public BasicFlagsPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = this.getString("LBL_BasicFlagsPanel");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        grid.anchor = 18;
        grid.fill = 2;
        grid.gridx = 0;
        grid.gridy = -1;
        grid.gridwidth = 0;
        grid.weightx = 1.0;
        this.add((Component)new JLabel(this.getString("LBL_BuildMode")), grid);
        this.develBuildRB = new JRadioButton(this.getString("RB_DevelBuild"));
        this.develBuildRB.setSelected(true);
        this.develBuildRB.setMnemonic(this.getString("MNEM_DevelBuild").charAt(0));
        this.add((Component)this.develBuildRB, grid);
        this.develDebugCodeRB = new JRadioButton(this.getString("RB_DebugFlag"));
        this.develDebugCodeRB.setSelected(true);
        this.develDebugCodeRB.setMnemonic(this.getString("MNEM_DebugFlag").charAt(0));
        grid.insets = new Insets(0, 17, 0, 0);
        this.add((Component)this.develDebugCodeRB, grid);
        this.develOptDebugCodeRB = new JRadioButton(this.getString("RB_OptDebugFlag"));
        this.develOptDebugCodeRB.setMnemonic(this.getString("MNEM_OptDebugFlag").charAt(0));
        this.add((Component)this.develOptDebugCodeRB, grid);
        ButtonGroup develGroup = new ButtonGroup();
        develGroup.add(this.develDebugCodeRB);
        develGroup.add(this.develOptDebugCodeRB);
        this.finalBuildRB = new JRadioButton(this.getString("RB_FinalBuild"));
        this.finalBuildRB.setMnemonic(this.getString("MNEM_FinalBuild").charAt(0));
        grid.insets.top = 5;
        grid.insets.left = 0;
        this.add((Component)this.finalBuildRB, grid);
        this.finalOptTB = new JCheckBox(this.getString("TB_OptimizeFlag"));
        this.finalOptTB.setMnemonic(this.getString("MNEM_OptimizeFlag").charAt(0));
        this.finalOptTB.setEnabled(false);
        grid.insets.top = 0;
        grid.insets.left = 17;
        this.add((Component)this.finalOptTB, grid);
        this.finalStripTB = new JCheckBox(this.getString("TB_StripFlag"));
        this.finalStripTB.setMnemonic(this.getString("MNEM_StripFlag").charAt(0));
        this.finalStripTB.setEnabled(false);
        this.add((Component)this.finalStripTB, grid);
        ButtonGroup buildGroup = new ButtonGroup();
        buildGroup.add(this.develBuildRB);
        buildGroup.add(this.finalBuildRB);
        this.create64BitTB = new JCheckBox(this.getString("TB_64BitFlag"));
        this.create64BitTB.setMnemonic(this.getString("MNEM_64BitFlag").charAt(0));
        grid.insets.top = 11;
        grid.insets.left = 0;
        this.add((Component)this.create64BitTB, grid);
        this.moduleSupportTB = new JCheckBox(this.getString("TB_EnableModuleSupport"));
        this.moduleSupportTB.setMnemonic(this.getString("MNEM_EnableModuleSupport").charAt(0));
        grid.insets.top = 5;
        this.add((Component)this.moduleSupportTB, grid);
        grid.gridwidth = 0;
        grid.gridheight = 0;
        grid.weightx = 1.0;
        grid.weighty = 1.0;
        this.add((Component)new JLabel(""), grid);
        this.develBuildRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (BasicFlagsPanel.this.develBuildRB.isSelected()) {
                    BasicFlagsPanel.this.develDebugCodeRB.setEnabled(true);
                    BasicFlagsPanel.this.develOptDebugCodeRB.setEnabled(true);
                } else {
                    BasicFlagsPanel.this.develDebugCodeRB.setEnabled(false);
                    BasicFlagsPanel.this.develOptDebugCodeRB.setEnabled(false);
                }
            }
        });
        this.finalBuildRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (BasicFlagsPanel.this.finalBuildRB.isSelected()) {
                    BasicFlagsPanel.this.finalOptTB.setEnabled(true);
                    BasicFlagsPanel.this.finalStripTB.setEnabled(true);
                } else {
                    BasicFlagsPanel.this.finalOptTB.setEnabled(false);
                    BasicFlagsPanel.this.finalStripTB.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void addNotify() {
        CompilerFlags copts = this.getMakefileData().getCompilerFlags();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        if (copts.getOptionSource() == OptionSource.DEVELOPMENT) {
            this.develBuildRB.setSelected(true);
        } else {
            this.finalBuildRB.setSelected(true);
        }
        this.finalOptTB.setSelected(copts.isFinalOptimize());
        this.finalStripTB.setSelected(copts.isFinalStrip());
        this.develDebugCodeRB.setSelected(copts.isDevelDebug());
        this.create64BitTB.setSelected(copts.is64Bit());
        this.moduleSupportTB.setSelected(this.getMakefileData().isModuleEnabled());
        if (this.getMakefileData().getToolset() == 1) {
            this.getMakefileData().setModuleEnabled(false);
            this.moduleSupportTB.setEnabled(false);
        }
        CndUIUtilities.requestFocus((Component)this.develBuildRB);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        CompilerFlags copts = this.getMakefileData().getCompilerFlags();
        if (this.develBuildRB.isSelected()) {
            copts.setOptionSource(OptionSource.DEVELOPMENT);
        } else {
            copts.setOptionSource(OptionSource.FINAL);
        }
        copts.setFinalOptimize(this.finalOptTB.isSelected());
        copts.setFinalStrip(this.finalStripTB.isSelected());
        copts.setDevelDebug(this.develDebugCodeRB.isSelected());
        copts.set64Bit(this.create64BitTB.isSelected());
        this.getMakefileData().setModuleEnabled(this.moduleSupportTB.isSelected());
    }
}

