<elements>
  <summary>
    <attribution license="cc4" from="Microsoft" modified="false" />
    <para>The <see cref="N:System.Linq" /> namespace provides classes and interfaces that support queries that use vbteclinqext.</para>
  </summary>
  <remarks>
    <attribution license="cc4" from="Microsoft" modified="false" />
    <para>The <see cref="N:System.Linq" /> namespace is in the System.Core assembly (in System.Core.dll).</para>
    <para>The <see cref="T:System.Linq.Enumerable" /> class contains vbteclinq standard query operators that operate on objects that implement <see cref="T:System.Collections.Generic.IEnumerable`1" />.</para>
    <para>The <see cref="T:System.Linq.Queryable" /> class contains vbteclinq standard query operators that operate on objects that implement <see cref="T:System.Linq.IQueryable`1" />.</para>
    <para>For information about LINQ to SQL, see <format type="text/html"><a href="73d13345-eece-471a-af40-4cc7a2f11655">LINQ to SQL</a></format>.</para>
  </remarks>
  <class name="Enumerable" fullname="System.Linq.Enumerable" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides a set of static (Shared in Visual Basic) methods for querying objects that implement <see cref="T:System.Collections.Generic.IEnumerable`1" />.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The methods in this class provide an implementation of the standard query operators for querying data sources that implement <see cref="T:System.Collections.Generic.IEnumerable`1" />. The standard query operators are general purpose methods that follow the vbteclinq pattern and enable you to express traversal, filter, and projection operations over data in any .NET-based programming language.</para>
      <para>The majority of the methods in this class are defined as extension methods that extend <see cref="T:System.Collections.Generic.IEnumerable`1" />. This means they can be called like an instance method on any object that implements <see cref="T:System.Collections.Generic.IEnumerable`1" />.</para>
      <para>Methods that are used in a query that returns a sequence of values do not consume the target data until the query object is enumerated. This is known as deferred execution. Methods that are used in a query that returns a singleton value execute and consume the target data immediately.</para>
    </remarks>
  </class>
  <class name="EnumerableExecutor" fullname="System.Linq.EnumerableExecutor" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an expression tree and provides functionality to execute the expression tree after rewriting it.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="EnumerableExecutor&lt;T&gt;" fullname="System.Linq.EnumerableExecutor&lt;T&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an expression tree and provides functionality to execute the expression tree after rewriting it.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="EnumerableQuery" fullname="System.Linq.EnumerableQuery" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an <see cref="T:System.Collections.IEnumerable" /> as an <see cref="T:System.Linq.EnumerableQuery" /> data source. </para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="EnumerableQuery&lt;T&gt;" fullname="System.Linq.EnumerableQuery&lt;T&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an <see cref="T:System.Collections.Generic.IEnumerable`1" /> collection as an <see cref="T:System.Linq.IQueryable`1" /> data source.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="IGrouping&lt;TKey,TElement&gt;" fullname="System.Linq.IGrouping&lt;TKey,TElement&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a collection of objects that have a common key.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>An <see cref="T:System.Linq.IGrouping`2" /> is an <see cref="T:System.Collections.Generic.IEnumerable`1" /> that additionally has a key. The key represents the attribute that is common to each value in the <see cref="T:System.Linq.IGrouping`2" />.</para>
      <para>The values of an <see cref="T:System.Linq.IGrouping`2" /> are accessed much as the elements of an <see cref="T:System.Collections.Generic.IEnumerable`1" /> are accessed. For example, you can access the values by using a foreach in csprcs or For Each in vbprvb loop to iterate through the <see cref="T:System.Linq.IGrouping`2" /> object. The Example section contains a code example that shows you how to access both the key and the values of an <see cref="T:System.Linq.IGrouping`2" /> object.</para>
      <para>The <see cref="T:System.Linq.IGrouping`2" /> type is used by the <see cref="Overload:System.Linq.Enumerable.GroupBy" /> standard query operator methods, which return a sequence of elements of type <see cref="T:System.Linq.IGrouping`2" />.</para>
    </remarks>
  </class>
  <class name="ILookup&lt;TKey,TElement&gt;" fullname="System.Linq.ILookup&lt;TKey,TElement&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Defines an indexer, size property, and Boolean search method for data structures that map keys to <see cref="T:System.Collections.Generic.IEnumerable`1" /> sequences of values.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The type <see cref="T:System.Linq.Lookup`2" /> implements the <see cref="T:System.Linq.ILookup`2" /> interface.</para>
      <para>The extension method <see cref="Overload:System.Linq.Enumerable.ToLookup" />, which can be appended to the end of a LINQ query, returns an object of type <see cref="T:System.Linq.ILookup`2" />.</para>
    </remarks>
  </class>
  <class name="IOrderedEnumerable&lt;TElement&gt;" fullname="System.Linq.IOrderedEnumerable&lt;TElement&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a sorted sequence.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This type is enumerable because it inherits from <see cref="T:System.Collections.Generic.IEnumerable`1" />.</para>
      <para>The extension methods <see cref="Overload:System.Linq.Enumerable.ThenBy" /> and <see cref="Overload:System.Linq.Enumerable.ThenByDescending" /> operate on objects of type <see cref="T:System.Linq.IOrderedEnumerable`1" />. An object of type <see cref="T:System.Linq.IOrderedEnumerable`1" /> can be obtained by calling one of the primary sort methods, <see cref="Overload:System.Linq.Enumerable.OrderBy" /> or <see cref="Overload:System.Linq.Enumerable.OrderByDescending" />, which return an <see cref="T:System.Linq.IOrderedEnumerable`1" />. <see cref="Overload:System.Linq.Enumerable.ThenBy" /> and <see cref="Overload:System.Linq.Enumerable.ThenByDescending" />, the subordinate sort methods, in turn also return an object of type <see cref="T:System.Linq.IOrderedEnumerable`1" />. This design allows for any number of consecutive calls to <see cref="Overload:System.Linq.Enumerable.ThenBy" /> or <see cref="Overload:System.Linq.Enumerable.ThenByDescending" />, where each call performs a subordinate ordering on the sorted data returned from the previous call.</para>
    </remarks>
  </class>
  <class name="IOrderedQueryable" fullname="System.Linq.IOrderedQueryable" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the result of a sorting operation.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Linq.IOrderedQueryable" /> interface is intended for implementation by query providers.</para>
      <para>This interface represents the result of a sorting query that calls the method(s) <see cref="Overload:System.Linq.Queryable.OrderBy" />, <see cref="Overload:System.Linq.Queryable.OrderByDescending" />, <see cref="Overload:System.Linq.Queryable.ThenBy" /> or <see cref="Overload:System.Linq.Queryable.ThenByDescending" />. When <see cref="M:System.Linq.IQueryProvider.CreateQuery(System.Linq.Expressions.Expression)" /> is called and passed an expression tree that represents a sorting query, the resulting <see cref="T:System.Linq.IQueryable" /> object must be of a type that implements <see cref="T:System.Linq.IOrderedQueryable" />.</para>
      <para>For more information about how to create your own LINQ provider, see <see cref="http://go.microsoft.com/fwlink/?LinkID=112370">LINQ: Building an IQueryable Provider</see> on MSDN Blogs.</para>
    </remarks>
  </class>
  <class name="IOrderedQueryable&lt;T&gt;" fullname="System.Linq.IOrderedQueryable&lt;T&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the result of a sorting operation.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Linq.IOrderedQueryable`1" /> interface is intended for implementation by query providers.</para>
      <para>This interface represents the result of a sorting query that calls the method(s) <see cref="Overload:System.Linq.Queryable.OrderBy" />, <see cref="Overload:System.Linq.Queryable.OrderByDescending" />, <see cref="Overload:System.Linq.Queryable.ThenBy" /> or <see cref="Overload:System.Linq.Queryable.ThenByDescending" />. When <see cref="M:System.Linq.IQueryProvider.CreateQuery``1(System.Linq.Expressions.Expression)" /> is called and passed an expression tree that represents a sorting query, the resulting <see cref="T:System.Linq.IQueryable`1" /> object must be of a type that implements <see cref="T:System.Linq.IOrderedQueryable`1" />.</para>
      <para>For more information about how to create your own LINQ provider, see <see cref="http://go.microsoft.com/fwlink/?LinkID=112370">LINQ: Building an IQueryable Provider</see> on MSDN Blogs.</para>
    </remarks>
  </class>
  <class name="IQueryable" fullname="System.Linq.IQueryable" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides functionality to evaluate queries against a specific data source wherein the type of the data is not specified.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Linq.IQueryable" /> interface is intended for implementation by query providers. It is only supposed to be implemented by providers that also implement <see cref="T:System.Linq.IQueryable`1" />. If the provider does not also implement <see cref="T:System.Linq.IQueryable`1" />, the standard query operators cannot be used on the provider's data source.</para>
      <para>The <see cref="T:System.Linq.IQueryable" /> interface inherits the <see cref="T:System.Collections.IEnumerable" /> interface so that if it represents a query, the results of that query can be enumerated. Enumeration causes the expression tree associated with an <see cref="T:System.Linq.IQueryable" /> object to be executed. The definition of "executing an expression tree" is specific to a query provider. For example, it may involve translating the expression tree to an appropriate query language for the underlying data source. Queries that do not return enumerable results are executed when the <see cref="M:System.Linq.IQueryProvider.Execute(System.Linq.Expressions.Expression)" /> method is called.</para>
      <para>For more information about how to create your own LINQ provider, see <see cref="http://go.microsoft.com/fwlink/?LinkID=112370">LINQ: Building an IQueryable Provider</see> on MSDN Blogs.</para>
    </remarks>
  </class>
  <class name="IQueryable&lt;T&gt;" fullname="System.Linq.IQueryable&lt;T&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides functionality to evaluate queries against a specific data source wherein the type of the data is known.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Linq.IQueryable`1" /> interface is intended for implementation by query providers.</para>
      <para>This interface inherits the <see cref="T:System.Collections.Generic.IEnumerable`1" /> interface so that if it represents a query, the results of that query can be enumerated. Enumeration forces the expression tree associated with an <see cref="T:System.Linq.IQueryable`1" /> object to be executed. Queries that do not return enumerable results are executed when the <see cref="M:System.Linq.IQueryProvider.Execute``1(System.Linq.Expressions.Expression)" /> method is called.</para>
      <para>The definition of "executing an expression tree" is specific to a query provider. For example, it may involve translating the expression tree to a query language appropriate for an underlying data source.</para>
      <para>The <see cref="T:System.Linq.IQueryable`1" /> interface enables queries to be polymorphic. That is, because a query against an <unmanagedCodeEntityReference>IQueryable</unmanagedCodeEntityReference> data source is represented as an expression tree, it can be executed against different types of data sources.</para>
      <para>The static (Shared in Visual Basic) methods defined in the class <see cref="T:System.Linq.Queryable" /> (except for <see cref="Overload:System.Linq.Queryable.AsQueryable" />, <see cref="Overload:System.Linq.Queryable.ThenBy" />, and <see cref="Overload:System.Linq.Queryable.ThenByDescending" />) extend objects of types that implement the <see cref="T:System.Linq.IQueryable`1" /> interface.</para>
      <para>For more information about how to create your own LINQ provider, see <see cref="http://go.microsoft.com/fwlink/?LinkID=112370">LINQ: Building an IQueryable Provider</see> on MSDN Blogs.</para>
    </remarks>
  </class>
  <class name="IQueryProvider" fullname="System.Linq.IQueryProvider" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Defines methods to create and execute queries that are described by an <see cref="T:System.Linq.IQueryable" /> object.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Linq.IQueryProvider" /> interface is intended for implementation by query providers.</para>
      <para>For more information about how to create your own LINQ provider, see <see cref="http://go.microsoft.com/fwlink/?LinkID=112370">LINQ: Building an IQueryable Provider</see> on MSDN Blogs.</para>
    </remarks>
  </class>
  <class name="Lookup&lt;TKey,TElement&gt;" fullname="System.Linq.Lookup&lt;TKey,TElement&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a collection of keys each mapped to one or more values.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>A <see cref="T:System.Linq.Lookup`2" /> resembles a <see cref="T:System.Collections.Generic.Dictionary`2" />. The difference is that a <see cref="T:System.Collections.Generic.Dictionary`2" /> maps keys to single values, whereas a <see cref="T:System.Linq.Lookup`2" /> maps keys to collections of values.</para>
      <para>You can create an instance of a <see cref="T:System.Linq.Lookup`2" /> by calling <see cref="M:System.Linq.Enumerable.ToLookup``2(System.Collections.Generic.IEnumerable{``0},System.Func{``0,``1})" /> on an object that implements <see cref="T:System.Collections.Generic.IEnumerable`1" />.</para>
      <block subset="none" type="note">
        <para>There is no public constructor to create a new instance of a <see cref="T:System.Linq.Lookup`2" />. Additionally, <see cref="T:System.Linq.Lookup`2" /> objects are immutable, that is, you cannot add or remove elements or keys from a <see cref="T:System.Linq.Lookup`2" /> object after it has been created.</para>
      </block>
    </remarks>
  </class>
  <class name="OrderedParallelQuery&lt;TSource&gt;" fullname="System.Linq.OrderedParallelQuery&lt;TSource&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a sorted, parallel sequence.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="ParallelEnumerable" fullname="System.Linq.ParallelEnumerable" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides a set of methods for querying objects that implement ParallelQuery{TSource}. This is the parallel equivalent of <see cref="T:System.Linq.Enumerable" />.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="ParallelExecutionMode" fullname="System.Linq.ParallelExecutionMode" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The query execution mode is a hint that specifies how the system should handle performance trade-offs when parallelizing queries.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="ParallelMergeOptions" fullname="System.Linq.ParallelMergeOptions" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies the preferred type of <newTerm>output merge</newTerm> to use in a query. In other words, it indicates how PLINQ should merge the results from the various partitions back into a single result sequence. This is a hint only, and may not be respected by the system when parallelizing all queries.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Use NotBuffered for queries that will be consumed and output as streams, this has the lowest latency between beginning query execution and elements being yielded. For some queries, such as those involving a sort (OrderBy, OrderByDescending), buffering is essential and a hint of NotBuffered or AutoBuffered will be ignored. However, queries that are created by using the AsOrdered operator can be streamed as long as no further sorting is performed within the query itself.</para>
      <para>Use AutoBuffered for most cases; this is the default. It strikes a balance between latency and overall performance. </para>
      <para>Use FullyBuffered for queries when the entire output can be processed before the information is needed. This option offers the best performance when all of the output can be accumulated before yielding any information, though it is not suitable for stream processing or showing partial results mid-query.</para>
    </remarks>
  </class>
  <class name="ParallelQuery" fullname="System.Linq.ParallelQuery" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a parallel sequence.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="ParallelQuery&lt;TSource&gt;" fullname="System.Linq.ParallelQuery&lt;TSource&gt;" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a parallel sequence.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="Queryable" fullname="System.Linq.Queryable" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides a set of static (Shared in Visual Basic) methods for querying data structures that implement <see cref="T:System.Linq.IQueryable`1" />.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The set of methods declared in the <see cref="T:System.Linq.Queryable" /> class provides an implementation of the standard query operators for querying data sources that implement <see cref="T:System.Linq.IQueryable`1" />. The standard query operators are general purpose methods that follow the vbteclinq pattern and enable you to express traversal, filter, and projection operations over data in any .NET-based programming language.</para>
      <para>The majority of the methods in this class are defined as extension methods that extend the <see cref="T:System.Linq.IQueryable`1" /> type. This means they can be called like an instance method on any object that implements <see cref="T:System.Linq.IQueryable`1" />. These methods that extend <see cref="T:System.Linq.IQueryable`1" /> do not perform any querying directly. Instead, their functionality is to build an <see cref="T:System.Linq.Expressions.Expression" /> object, which is an expression tree that represents the cumulative query. The methods then pass the new expression tree to either the <see cref="M:System.Linq.IQueryProvider.Execute``1(System.Linq.Expressions.Expression)" /> method or the <see cref="M:System.Linq.IQueryProvider.CreateQuery``1(System.Linq.Expressions.Expression)" /> method of the input <see cref="T:System.Linq.IQueryable`1" />. The method that is called depends on whether the <see cref="T:System.Linq.Queryable" /> method returns a singleton value, in which case <see cref="M:System.Linq.IQueryProvider.Execute``1(System.Linq.Expressions.Expression)" /> is called, or has enumerable results, in which case <see cref="M:System.Linq.IQueryProvider.CreateQuery``1(System.Linq.Expressions.Expression)" /> is called.</para>
      <para>The actual query execution on the target data is performed by a class that implements <see cref="T:System.Linq.IQueryable`1" />. The expectation of any <see cref="T:System.Linq.IQueryable`1" /> implementation is that the result of executing an expression tree that was constructed by a <see cref="T:System.Linq.Queryable" /> standard query operator method is equivalent to the result of calling the corresponding method in the <see cref="T:System.Linq.Enumerable" /> class, if the data source were an <see cref="T:System.Collections.Generic.IEnumerable`1" />.</para>
      <para>In addition to the standard query operator methods that operate on <see cref="T:System.Linq.IQueryable`1" /> objects, this class also contains a method, <see cref="Overload:System.Linq.Queryable.AsQueryable" />, which types <see cref="T:System.Collections.IEnumerable" /> objects as <see cref="T:System.Linq.IQueryable" /> objects.</para>
    </remarks>
  </class>
</elements>