/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.auth;

import java.util.Objects;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public class AuthenticationSession {
    private final String machineUID;
    private final String sessionId;
    private final String userIdentity;
    private long activityTimestamp = System.currentTimeMillis();
    private Jid userJabberId;
    private EntityBareJid roomName;

    public AuthenticationSession(String machineUID, String sessionId, String userIdentity, EntityBareJid roomName) {
        this.machineUID = Objects.requireNonNull(machineUID, "machineUID");
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId");
        this.userIdentity = Objects.requireNonNull(userIdentity, "userIdentity");
        this.roomName = roomName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserIdentity() {
        return this.userIdentity;
    }

    public long getActivityTimestamp() {
        return this.activityTimestamp;
    }

    public void touch() {
        this.activityTimestamp = System.currentTimeMillis();
    }

    public Jid getUserJabberId() {
        return this.userJabberId;
    }

    public void setUserJabberId(Jid userJabberId) {
        this.userJabberId = userJabberId;
    }

    public String getMachineUID() {
        return this.machineUID;
    }

    public EntityBareJid getRoomName() {
        return this.roomName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AuthSession[");
        builder.append("ID=").append(this.userIdentity);
        builder.append(", JID=").append((CharSequence)this.userJabberId);
        builder.append(", SID=").append(this.sessionId);
        builder.append(", MUID=").append(this.machineUID);
        long lifetime = System.currentTimeMillis() - this.activityTimestamp;
        builder.append(", LIFE_TM_SEC=").append(lifetime / 1000L);
        builder.append(", R=").append((CharSequence)this.roomName);
        builder.append("]@").append(this.hashCode());
        return builder.toString();
    }
}

