/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.JicofoConfig;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeSelectionStrategy;
import org.jitsi.jicofo.bridge.ConferenceBridgeProperties;
import org.jitsi.jicofo.bridge.ParticipantProperties;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J<\u0010\u0010\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/jicofo/bridge/RegionBasedBridgeSelectionStrategy;", "Lorg/jitsi/jicofo/bridge/BridgeSelectionStrategy;", "()V", "localRegion", "", "getLocalRegion", "()Ljava/lang/String;", "doSelect", "Lorg/jitsi/jicofo/bridge/Bridge;", "bridges", "", "conferenceBridges", "", "Lorg/jitsi/jicofo/bridge/ConferenceBridgeProperties;", "participantProperties", "Lorg/jitsi/jicofo/bridge/ParticipantProperties;", "select", "allowMultiBridge", "", "toString", "Companion", "jicofo-selector"})
public final class RegionBasedBridgeSelectionStrategy
extends BridgeSelectionStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String localRegion = JicofoConfig.config.localRegion();
    @NotNull
    private static final Logger logger = (Logger)new LoggerImpl(RegionBasedBridgeSelectionStrategy.class.getName());

    @Nullable
    public final String getLocalRegion() {
        return this.localRegion;
    }

    @Override
    @Nullable
    public Bridge doSelect(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        Bridge bridge2;
        String region;
        Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
        Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
        if (bridges.isEmpty()) {
            return null;
        }
        String participantRegion = participantProperties.getRegion();
        String string = participantRegion;
        if (string == null) {
            string = region = this.localRegion;
        }
        if (this.localRegion != null) {
            boolean bl;
            block9: {
                Set<String> regionGroup = this.getRegionGroup(region);
                if (conferenceBridges.isEmpty() && !Intrinsics.areEqual((Object)region, (Object)this.localRegion) && regionGroup.contains(this.localRegion)) {
                    region = this.localRegion;
                }
                Iterable $this$none$iv = bridges;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Bridge it = (Bridge)element$iv;
                        boolean bl2 = false;
                        if (!CollectionsKt.contains((Iterable)regionGroup, (Object)it.getRegion())) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                region = this.localRegion;
            }
        }
        if ((bridge2 = this.notLoadedAlreadyInConferenceInRegion(bridges, conferenceBridges, participantProperties, region)) == null && (bridge2 = this.notLoadedAlreadyInConferenceInRegionGroup(bridges, conferenceBridges, participantProperties, region)) == null && (bridge2 = this.notLoadedInRegion(bridges, conferenceBridges, participantProperties, region)) == null && (bridge2 = this.notLoadedInRegionGroup(bridges, conferenceBridges, participantProperties, region)) == null && (bridge2 = this.leastLoadedAlreadyInConferenceInRegion(bridges, conferenceBridges, participantProperties, region)) == null && (bridge2 = this.leastLoadedAlreadyInConferenceInRegionGroup(bridges, conferenceBridges, participantProperties, region)) == null && (bridge2 = this.leastLoadedInRegion(bridges, conferenceBridges, participantProperties, region)) == null && (bridge2 = this.leastLoadedInRegionGroup(bridges, conferenceBridges, participantProperties, region)) == null && (bridge2 = this.nonLoadedAlreadyInConference(bridges, conferenceBridges, participantProperties)) == null) {
            bridge2 = this.leastLoaded(bridges, conferenceBridges, participantProperties);
        }
        return bridge2;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " with region groups: " + BridgeConfig.config.getRegionGroups();
    }

    @Override
    @Nullable
    public Bridge select(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, boolean allowMultiBridge) {
        Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
        Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
        if (!allowMultiBridge) {
            logger.warn((Object)"Octo is disabled, but the selection strategy is RegionBased. Enable octo in jicofo.conf to allow use of multiple bridges in a conference.");
        }
        return super.select(bridges, conferenceBridges, participantProperties, allowMultiBridge);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/jicofo/bridge/RegionBasedBridgeSelectionStrategy$Companion;", "", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "jicofo-selector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

