/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.http;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.spdy.AsyncConnectionFactory;
import org.eclipse.jetty.spdy.http.AbstractHTTPSPDYServerConnector;
import org.eclipse.jetty.spdy.http.PushStrategy;
import org.eclipse.jetty.spdy.http.ServerHTTPAsyncConnectionFactory;
import org.eclipse.jetty.spdy.http.ServerHTTPSPDYAsyncConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HTTPSPDYServerConnector
extends AbstractHTTPSPDYServerConnector {
    public HTTPSPDYServerConnector() {
        this(null, Collections.emptyMap());
    }

    public HTTPSPDYServerConnector(Map<Short, PushStrategy> pushStrategies) {
        this(null, pushStrategies);
    }

    public HTTPSPDYServerConnector(SslContextFactory sslContextFactory) {
        this(sslContextFactory, Collections.emptyMap());
    }

    public HTTPSPDYServerConnector(SslContextFactory sslContextFactory, Map<Short, PushStrategy> pushStrategies) {
        super(null, sslContextFactory);
        this.clearAsyncConnectionFactories();
        this.putAsyncConnectionFactory("spdy/3", (AsyncConnectionFactory)new ServerHTTPSPDYAsyncConnectionFactory(3, this.getByteBufferPool(), this.getExecutor(), this.getScheduler(), (Connector)this, this.getPushStrategy((short)3, pushStrategies)));
        this.putAsyncConnectionFactory("spdy/2", (AsyncConnectionFactory)new ServerHTTPSPDYAsyncConnectionFactory(2, this.getByteBufferPool(), this.getExecutor(), this.getScheduler(), (Connector)this, this.getPushStrategy((short)2, pushStrategies)));
        this.putAsyncConnectionFactory("http/1.1", new ServerHTTPAsyncConnectionFactory(this));
        this.setDefaultAsyncConnectionFactory(this.getAsyncConnectionFactory("http/1.1"));
    }

    private PushStrategy getPushStrategy(short version, Map<Short, PushStrategy> pushStrategies) {
        PushStrategy pushStrategy = pushStrategies.get(version);
        if (pushStrategy == null) {
            pushStrategy = new PushStrategy.None();
        }
        return pushStrategy;
    }
}

