/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer;

import jd.core.loader.Loader;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.CodeException;
import jd.core.model.classfile.attribute.LineNumber;
import jd.core.model.classfile.constant.Constant;
import jd.core.model.classfile.constant.ConstantClass;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.ByteCodeConstants;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.Printer;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.process.writer.SignatureWriter;

public class ByteCodeWriter {
    private static final String CORRUPTED_CONSTANT_POOL = "Corrupted_Constant_Pool";

    public static void Write(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, Method method) {
        byte[] code = method.getCode();
        if (code != null) {
            int length = code.length;
            int ioperande = 0;
            short soperande = 0;
            printer.startOfComment();
            ConstantPool constants = classFile.getConstantPool();
            printer.print("// Byte code:");
            int index = 0;
            while (index < length) {
                int offset = index;
                int opcode = code[index] & 0xFF;
                printer.endOfLine();
                printer.startOfLine(Instruction.UNKNOWN_LINE_NUMBER);
                printer.print("//   ");
                printer.print(offset);
                printer.print(": ");
                printer.print(ByteCodeConstants.OPCODE_NAMES[opcode]);
                block0 : switch (ByteCodeConstants.NO_OF_OPERANDS[opcode]) {
                    case 1: {
                        printer.print(" ");
                        switch (opcode) {
                            case 188: {
                                printer.print(ByteCodeConstants.TYPE_NAMES[code[++index] & 0x10]);
                                break block0;
                            }
                        }
                        printer.print(code[++index]);
                        break;
                    }
                    case 2: {
                        printer.print(" ");
                        switch (opcode) {
                            case 132: {
                                printer.print(code[++index]);
                                printer.print(" ");
                                printer.print(code[++index]);
                                break block0;
                            }
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 198: 
                            case 199: {
                                soperande = (short)((code[++index] & 0xFF) << 8 | code[++index] & 0xFF);
                                if (soperande >= 0) {
                                    printer.print('+');
                                }
                                printer.print(soperande);
                                printer.print(" -> ");
                                printer.print(index + soperande - 2);
                                break block0;
                            }
                            case 178: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 285: {
                                ioperande = (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(ioperande);
                                printer.print("\t");
                                String fieldName = ByteCodeWriter.GetConstantFieldName(constants, ioperande);
                                if (fieldName == null) {
                                    printer.startOfError();
                                    printer.print(CORRUPTED_CONSTANT_POOL);
                                    printer.endOfError();
                                    break block0;
                                }
                                printer.print(fieldName);
                                break block0;
                            }
                            case 182: 
                            case 183: 
                            case 184: {
                                ioperande = (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(ioperande);
                                printer.print("\t");
                                String methodName = ByteCodeWriter.GetConstantMethodName(constants, ioperande);
                                if (methodName == null) {
                                    printer.startOfError();
                                    printer.print(CORRUPTED_CONSTANT_POOL);
                                    printer.endOfError();
                                    break block0;
                                }
                                printer.print(methodName);
                                break block0;
                            }
                            case 187: 
                            case 189: 
                            case 192: {
                                ioperande = (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(ioperande);
                                printer.print("\t");
                                Constant c = constants.get(ioperande);
                                if (c.tag == 7) {
                                    ConstantClass cc = (ConstantClass)c;
                                    printer.print(constants.getConstantUtf8(cc.name_index));
                                    break block0;
                                }
                                printer.print(CORRUPTED_CONSTANT_POOL);
                                break block0;
                            }
                        }
                        ioperande = (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                        printer.print(ioperande);
                        break;
                    }
                    default: {
                        switch (opcode) {
                            case 197: {
                                printer.print(" ");
                                printer.print((code[++index] & 0xFF) << 8 | code[++index] & 0xFF);
                                printer.print(" ");
                                printer.print(code[++index]);
                                break block0;
                            }
                            case 185: {
                                printer.print(" ");
                                printer.print((code[++index] & 0xFF) << 8 | code[++index] & 0xFF);
                                printer.print(" ");
                                printer.print(code[++index]);
                                printer.print(" ");
                                printer.print(code[++index]);
                                break block0;
                            }
                            case 170: {
                                index = (index + 4 & 0xFFFC) - 1;
                                printer.print("\tdefault:+");
                                int jump = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(jump);
                                printer.print("->");
                                printer.print(offset + jump);
                                int low = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                int high = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                int value = low;
                                while (value <= high) {
                                    printer.print(", ");
                                    printer.print(value);
                                    printer.print(":+");
                                    jump = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                    printer.print(jump);
                                    printer.print("->");
                                    printer.print(offset + jump);
                                    ++value;
                                }
                                break block0;
                            }
                            case 171: {
                                index = (index + 4 & 0xFFFC) - 1;
                                printer.print("\tdefault:+");
                                int jump = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(jump);
                                printer.print("->");
                                printer.print(offset + jump);
                                int npairs = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                int i = 0;
                                while (i < npairs) {
                                    printer.print(", ");
                                    printer.print((code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF);
                                    printer.print(":+");
                                    jump = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                    printer.print(jump);
                                    printer.print("->");
                                    printer.print(offset + jump);
                                    ++i;
                                }
                                break block0;
                            }
                            case 196: {
                                index = ByteCodeUtil.NextWideOffset(code, index);
                                break block0;
                            }
                            default: {
                                int j = ByteCodeConstants.NO_OF_OPERANDS[opcode];
                                while (j > 0) {
                                    printer.print(" ");
                                    printer.print(code[++index]);
                                    --j;
                                }
                                break block0;
                            }
                        }
                    }
                }
                ++index;
            }
            ByteCodeWriter.WriteAttributeNumberTables(printer, method);
            ByteCodeWriter.WriteAttributeLocalVariableTables(loader, printer, referenceMap, classFile, method);
            ByteCodeWriter.WriteCodeExceptions(printer, referenceMap, classFile, method);
            printer.endOfComment();
        }
    }

    private static void WriteAttributeNumberTables(Printer printer, Method method) {
        LineNumber[] lineNumbers = method.getLineNumbers();
        if (lineNumbers != null) {
            printer.endOfLine();
            printer.startOfLine(Instruction.UNKNOWN_LINE_NUMBER);
            printer.print("// Line number table:");
            int i = 0;
            while (i < lineNumbers.length) {
                printer.endOfLine();
                printer.startOfLine(Instruction.UNKNOWN_LINE_NUMBER);
                printer.print("//   Java source line #");
                printer.print(lineNumbers[i].line_number);
                printer.print("\t-> byte code offset #");
                printer.print(lineNumbers[i].start_pc);
                ++i;
            }
        }
    }

    private static void WriteAttributeLocalVariableTables(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, Method method) {
        LocalVariables localVariables = method.getLocalVariables();
        if (localVariables != null) {
            int length = localVariables.size();
            printer.endOfLine();
            printer.startOfLine(Instruction.UNKNOWN_LINE_NUMBER);
            printer.print("// Local variable table:");
            printer.endOfLine();
            printer.startOfLine(Instruction.UNKNOWN_LINE_NUMBER);
            printer.print("//   start\tlength\tslot\tname\tsignature");
            ConstantPool constants = classFile.getConstantPool();
            int i = 0;
            while (i < length) {
                LocalVariable lv = localVariables.getLocalVariableAt(i);
                if (lv != null) {
                    printer.endOfLine();
                    printer.startOfLine(Instruction.UNKNOWN_LINE_NUMBER);
                    printer.print("//   ");
                    printer.print(lv.start_pc);
                    printer.print("\t");
                    printer.print(lv.length);
                    printer.print("\t");
                    printer.print(lv.index);
                    printer.print("\t");
                    if (lv.name_index > 0) {
                        printer.print(constants.getConstantUtf8(lv.name_index));
                    } else {
                        printer.print("???");
                    }
                    printer.print("\t");
                    if (lv.signature_index > 0) {
                        SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, constants.getConstantUtf8(lv.signature_index));
                    } else {
                        printer.print("???");
                    }
                }
                ++i;
            }
        }
    }

    private static void WriteCodeExceptions(Printer printer, ReferenceMap referenceMap, ClassFile classFile, Method method) {
        CodeException[] codeExceptions = method.getCodeExceptions();
        if (codeExceptions != null && codeExceptions.length > 0) {
            printer.endOfLine();
            printer.startOfLine(Instruction.UNKNOWN_LINE_NUMBER);
            printer.print("// Exception table:");
            printer.endOfLine();
            printer.startOfLine(Instruction.UNKNOWN_LINE_NUMBER);
            printer.print("//   from\tto\ttarget\ttype");
            int i = 0;
            while (i < codeExceptions.length) {
                printer.endOfLine();
                printer.startOfLine(Instruction.UNKNOWN_LINE_NUMBER);
                printer.print("//   ");
                printer.print(codeExceptions[i].start_pc);
                printer.print("\t");
                printer.print(codeExceptions[i].end_pc);
                printer.print("\t");
                printer.print(codeExceptions[i].handler_pc);
                printer.print("\t");
                if (codeExceptions[i].catch_type == 0) {
                    printer.print("finally");
                } else {
                    printer.print(classFile.getConstantPool().getConstantClassName(codeExceptions[i].catch_type));
                }
                ++i;
            }
        }
    }

    private static String GetConstantFieldName(ConstantPool constants, int index) {
        ConstantClass cc;
        ConstantFieldref cfr;
        Constant c = constants.get(index);
        switch (c.tag) {
            case 9: {
                cfr = (ConstantFieldref)c;
                break;
            }
            default: {
                return null;
            }
        }
        c = constants.get(cfr.class_index);
        switch (c.tag) {
            case 7: {
                cc = (ConstantClass)c;
                break;
            }
            default: {
                return null;
            }
        }
        String classPath = constants.getConstantUtf8(cc.name_index);
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
        String fieldName = constants.getConstantUtf8(cnat.name_index);
        String fieldDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        return String.valueOf(classPath) + ':' + fieldName + "\t" + fieldDescriptor;
    }

    private static String GetConstantMethodName(ConstantPool constants, int index) {
        ConstantClass cc;
        ConstantMethodref cfr;
        Constant c = constants.get(index);
        switch (c.tag) {
            case 10: 
            case 11: {
                cfr = (ConstantMethodref)c;
                break;
            }
            default: {
                return null;
            }
        }
        c = constants.get(cfr.class_index);
        switch (c.tag) {
            case 7: {
                cc = (ConstantClass)c;
                break;
            }
            default: {
                return null;
            }
        }
        String classPath = constants.getConstantUtf8(cc.name_index);
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
        String fieldName = constants.getConstantUtf8(cnat.name_index);
        String fieldDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        return String.valueOf(classPath) + ':' + fieldName + "\t" + fieldDescriptor;
    }
}

