/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonInstructionAnalyzer {
    /*
     * Enabled aggressive block sorting
     */
    public static void Aggregate(List<Instruction> list) {
        int afterOffest = -1;
        int index = list.size();
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            block0 : switch (instruction.opcode) {
                case 260: 
                case 261: 
                case 262: {
                    if (index <= 0) break;
                    Instruction prevI = list.get(index - 1);
                    switch (prevI.opcode) {
                        case 167: 
                        case 260: 
                        case 261: 
                        case 262: {
                            BranchInstruction bi = (BranchInstruction)instruction;
                            BranchInstruction prevBi = (BranchInstruction)prevI;
                            int prevBiJumpOffset = prevBi.GetJumpOffset();
                            if (prevBiJumpOffset != bi.GetJumpOffset() && (prevBi.branch <= 0 || prevBiJumpOffset > afterOffest)) break block0;
                            index = ComparisonInstructionAnalyzer.AnalyzeIfInstructions(list, index, bi, afterOffest);
                        }
                    }
                    break;
                }
            }
            afterOffest = instruction.offset;
        }
    }

    private static int AnalyzeIfInstructions(List<Instruction> list, int index, BranchInstruction lastBi, int afterOffest) {
        int arrayLength = list.get((int)(list.size() - 1)).offset;
        boolean[] offsetToPreviousGotoFlag = new boolean[arrayLength];
        boolean[] inversedTernaryOpLogic = new boolean[arrayLength];
        int firstIndex = ComparisonInstructionAnalyzer.SearchFirstIndex(list, index, lastBi, afterOffest, offsetToPreviousGotoFlag, inversedTernaryOpLogic);
        if ((firstIndex = ComparisonInstructionAnalyzer.ReduceFirstIndex(list, firstIndex, index)) < index) {
            ArrayList<Instruction> branchInstructions = new ArrayList<Instruction>(index - firstIndex + 1);
            branchInstructions.add(lastBi);
            while (index > firstIndex) {
                branchInstructions.add(list.remove(--index));
            }
            Collections.reverse(branchInstructions);
            list.set(index, ComparisonInstructionAnalyzer.CreateIfInstructions(offsetToPreviousGotoFlag, inversedTernaryOpLogic, branchInstructions, lastBi));
        }
        return index;
    }

    private static int ReduceFirstIndex(List<Instruction> list, int firstIndex, int lastIndex) {
        int jumpOffset;
        Instruction i;
        int firstOffset;
        int newFirstOffset = firstOffset = firstIndex == 0 ? 0 : list.get((int)(firstIndex - 1)).offset;
        int lastOffset = list.get((int)lastIndex).offset;
        int index = firstIndex;
        block6: while (index-- > 0) {
            i = list.get(index);
            switch (i.opcode) {
                case 167: 
                case 260: 
                case 261: 
                case 262: {
                    jumpOffset = ((BranchInstruction)i).GetJumpOffset();
                    if (newFirstOffset >= jumpOffset || jumpOffset > lastOffset) continue block6;
                    newFirstOffset = jumpOffset;
                }
            }
        }
        index = list.size();
        block7: while (--index > lastIndex) {
            i = list.get(index);
            switch (i.opcode) {
                case 167: 
                case 260: 
                case 261: 
                case 262: {
                    jumpOffset = ((BranchInstruction)i).GetJumpOffset();
                    if (newFirstOffset >= jumpOffset || jumpOffset > lastOffset) continue block7;
                    newFirstOffset = jumpOffset;
                }
            }
        }
        if (newFirstOffset != firstOffset) {
            index = firstIndex;
            while (index <= lastIndex) {
                i = list.get(index);
                if (i.offset > newFirstOffset) {
                    firstIndex = index;
                    break;
                }
                ++index;
            }
        }
        return firstIndex;
    }

    private static int SearchFirstIndex(List<Instruction> list, int lastIndex, BranchInstruction lastBi, int afterOffest, boolean[] offsetToPreviousGotoFlag, boolean[] inversedTernaryOpLogic) {
        int index = lastIndex;
        int lastBiJumpOffset = lastBi.GetJumpOffset();
        Instruction nextInstruction = lastBi;
        while (index-- > 0) {
            int jumpOffset;
            Instruction instruction = list.get(index);
            int opcode = instruction.opcode;
            if (opcode == 260 || opcode == 261 || opcode == 262) {
                BranchInstruction bi = (BranchInstruction)instruction;
                jumpOffset = bi.GetJumpOffset();
                if (jumpOffset == lastBiJumpOffset) {
                    if (bi.branch > 0 && instruction.lineNumber != Instruction.UNKNOWN_LINE_NUMBER && nextInstruction.lineNumber != Instruction.UNKNOWN_LINE_NUMBER) {
                        if (instruction.lineNumber + 2 <= nextInstruction.lineNumber) break;
                        int lenght = list.size();
                        boolean instructionBetweenIf = false;
                        int i = lastIndex + 1;
                        while (i < lenght) {
                            int lineNumber;
                            Instruction ins = list.get(i);
                            if (ins.opcode == 132 && (lineNumber = ins.lineNumber) != Instruction.UNKNOWN_LINE_NUMBER && instruction.lineNumber <= lineNumber && lineNumber < nextInstruction.lineNumber) {
                                instructionBetweenIf = true;
                                break;
                            }
                            ++i;
                        }
                        if (instructionBetweenIf) {
                            break;
                        }
                    }
                } else if (jumpOffset != lastBiJumpOffset && (bi.branch <= 0 || jumpOffset > afterOffest)) {
                    break;
                }
            } else {
                int j;
                int nextOffset;
                int jumpOffsetValue1;
                Goto g;
                if (opcode != 167 || (jumpOffset = (g = (Goto)instruction).GetJumpOffset()) != lastBiJumpOffset && (jumpOffset <= nextInstruction.offset || jumpOffset > afterOffest) || index <= 0) break;
                Instruction lastInstructionValue1 = list.get(index - 1);
                opcode = lastInstructionValue1.opcode;
                if (opcode != 260 && opcode != 261 && opcode != 262 || g.offset < (jumpOffsetValue1 = ((BranchInstruction)lastInstructionValue1).GetJumpOffset()) && jumpOffsetValue1 <= lastBi.offset) break;
                Instruction lastInstructionValue2 = list.get(lastIndex);
                int jumpIndex = lastIndex - 1;
                while (jumpIndex > index) {
                    Instruction jumpInstruction = list.get(jumpIndex);
                    if (jumpOffset > jumpInstruction.offset) {
                        lastInstructionValue2 = jumpInstruction;
                        break;
                    }
                    --jumpIndex;
                }
                opcode = lastInstructionValue2.opcode;
                if (opcode != 260 && opcode != 261 && opcode != 262) break;
                int jumpOffsetValue2 = ((BranchInstruction)lastInstructionValue2).GetJumpOffset();
                if (jumpOffsetValue1 == jumpOffsetValue2) {
                    nextOffset = nextInstruction.offset;
                    j = g.offset + 1;
                    while (j < nextOffset) {
                        offsetToPreviousGotoFlag[j] = true;
                        ++j;
                    }
                } else {
                    if (jumpOffset != jumpOffsetValue2) break;
                    nextOffset = nextInstruction.offset;
                    j = g.offset + 1;
                    while (j < nextOffset) {
                        offsetToPreviousGotoFlag[j] = true;
                        ++j;
                    }
                    inversedTernaryOpLogic[g.offset] = true;
                }
            }
            nextInstruction = instruction;
        }
        return index + 1;
    }

    private static ComplexConditionalBranchInstruction CreateIfInstructions(boolean[] offsetToPreviousGotoFlag, boolean[] inversedTernaryOpLogic, List<Instruction> branchInstructions, BranchInstruction lastBi) {
        ComparisonInstructionAnalyzer.ReconstructTernaryOperators(offsetToPreviousGotoFlag, inversedTernaryOpLogic, branchInstructions, lastBi);
        ComplexConditionalBranchInstruction cbl = ComparisonInstructionAnalyzer.AssembleAndCreateIfInstructions(branchInstructions, lastBi);
        ComparisonInstructionAnalyzer.SetOperator(cbl, lastBi, false);
        return cbl;
    }

    private static void ReconstructTernaryOperators(boolean[] offsetToPreviousGotoFlag, boolean[] inversedTernaryOpLogic, List<Instruction> branchInstructions, BranchInstruction lastBi) {
        if (branchInstructions.size() <= 1) {
            return;
        }
        int index = branchInstructions.size() - 1;
        int nextOffest = branchInstructions.get((int)index).offset;
        while (index-- > 0) {
            Instruction i = branchInstructions.get(index);
            switch (i.opcode) {
                case 260: 
                case 261: 
                case 262: {
                    BranchInstruction value2;
                    int gotoJumpOffset;
                    BranchInstruction value1;
                    BranchInstruction test;
                    BranchInstruction lastTernaryOpTestBi = (BranchInstruction)i;
                    int lastTernaryOpTestBiJumpOffset = lastTernaryOpTestBi.GetJumpOffset();
                    if (lastTernaryOpTestBiJumpOffset < 0 || lastBi.offset < lastTernaryOpTestBiJumpOffset || !offsetToPreviousGotoFlag[lastTernaryOpTestBiJumpOffset]) break;
                    ArrayList<Instruction> ternaryOpTestInstructions = new ArrayList<Instruction>();
                    ternaryOpTestInstructions.add(lastTernaryOpTestBi);
                    while (index > 0) {
                        Instruction ternaryOpTestInstruction = branchInstructions.get(--index);
                        int opcode = ternaryOpTestInstruction.opcode;
                        if (opcode != 260 && opcode != 261 && opcode != 262 && opcode != 167) {
                            ++index;
                            break;
                        }
                        BranchInstruction bi = (BranchInstruction)ternaryOpTestInstruction;
                        int branchOffset = bi.branch;
                        int jumpOffset = bi.offset + branchOffset;
                        if (jumpOffset != lastTernaryOpTestBiJumpOffset && (branchOffset <= 0 || jumpOffset > nextOffest)) {
                            ++index;
                            break;
                        }
                        branchInstructions.remove(index);
                        ternaryOpTestInstructions.add(ternaryOpTestInstruction);
                    }
                    if (ternaryOpTestInstructions.size() > 1) {
                        Collections.reverse(ternaryOpTestInstructions);
                        test = ComparisonInstructionAnalyzer.CreateIfInstructions(offsetToPreviousGotoFlag, inversedTernaryOpLogic, ternaryOpTestInstructions, lastTernaryOpTestBi);
                    } else {
                        test = lastTernaryOpTestBi;
                    }
                    ComparisonInstructionAnalyzer.InverseComparison(test);
                    ArrayList<Instruction> ternaryOpValue1Instructions = new ArrayList<Instruction>();
                    ++index;
                    while (index < branchInstructions.size()) {
                        Instruction instruction = branchInstructions.get(index);
                        if (instruction.offset >= lastTernaryOpTestBiJumpOffset) break;
                        ternaryOpValue1Instructions.add(instruction);
                        branchInstructions.remove(index);
                    }
                    Goto g = (Goto)ternaryOpValue1Instructions.remove(ternaryOpValue1Instructions.size() - 1);
                    if (ternaryOpValue1Instructions.size() > 1) {
                        BranchInstruction lastTernaryOpValueBi = (BranchInstruction)ternaryOpValue1Instructions.get(ternaryOpValue1Instructions.size() - 1);
                        value1 = ComparisonInstructionAnalyzer.AssembleAndCreateIfInstructions(ternaryOpValue1Instructions, lastTernaryOpValueBi);
                    } else {
                        value1 = (BranchInstruction)ternaryOpValue1Instructions.get(ternaryOpValue1Instructions.size() - 1);
                    }
                    if (inversedTernaryOpLogic[g.offset]) {
                        gotoJumpOffset = value1.GetJumpOffset();
                        ComparisonInstructionAnalyzer.InverseComparison(value1);
                    } else {
                        gotoJumpOffset = g.GetJumpOffset();
                    }
                    ArrayList<Instruction> ternaryOpValue2Instructions = new ArrayList<Instruction>();
                    while (index < branchInstructions.size()) {
                        Instruction instruction = branchInstructions.get(index);
                        if (instruction.opcode == 167 || instruction.offset >= gotoJumpOffset) break;
                        ternaryOpValue2Instructions.add(instruction);
                        branchInstructions.remove(index);
                    }
                    if (ternaryOpValue2Instructions.size() > 1) {
                        BranchInstruction lastTernaryOpValueBi = (BranchInstruction)ternaryOpValue2Instructions.get(ternaryOpValue2Instructions.size() - 1);
                        value2 = ComparisonInstructionAnalyzer.AssembleAndCreateIfInstructions(ternaryOpValue2Instructions, lastTernaryOpValueBi);
                    } else {
                        value2 = (BranchInstruction)ternaryOpValue2Instructions.get(ternaryOpValue2Instructions.size() - 1);
                    }
                    --index;
                    TernaryOperator to = new TernaryOperator(281, value2.offset, test.lineNumber, test, value1, value2);
                    ArrayList<Instruction> instructions = new ArrayList<Instruction>(1);
                    instructions.add(to);
                    ComplexConditionalBranchInstruction cbl = new ComplexConditionalBranchInstruction(284, value2.offset, test.lineNumber, 1, instructions, value2.branch);
                    branchInstructions.set(index, cbl);
                }
            }
            nextOffest = i.offset;
        }
    }

    private static ComplexConditionalBranchInstruction AssembleAndCreateIfInstructions(List<Instruction> branchInstructions, BranchInstruction lastBi) {
        int length = branchInstructions.size();
        int lastBiOffset = lastBi.offset;
        int i = 0;
        while (i < length) {
            BranchInstruction branchInstruction = (BranchInstruction)branchInstructions.get(i);
            int jumpOffset = branchInstruction.GetJumpOffset();
            if (branchInstruction.branch > 0 && jumpOffset < lastBiOffset) {
                BranchInstruction subLastBi = lastBi;
                ArrayList<Instruction> subBranchInstructions = new ArrayList<Instruction>();
                subBranchInstructions.add(branchInstruction);
                ++i;
                while (i < length) {
                    branchInstruction = (BranchInstruction)branchInstructions.get(i);
                    if (branchInstruction.offset >= jumpOffset) break;
                    subBranchInstructions.add(branchInstruction);
                    subLastBi = branchInstruction;
                    branchInstructions.remove(i);
                    --length;
                }
                --i;
                if (subBranchInstructions.size() > 1) {
                    branchInstructions.set(i, ComparisonInstructionAnalyzer.AssembleAndCreateIfInstructions(subBranchInstructions, subLastBi));
                }
            }
            ++i;
        }
        ComparisonInstructionAnalyzer.AnalyzeLastTestBlock(branchInstructions);
        int lineNumber = branchInstructions.get((int)0).lineNumber;
        return new ComplexConditionalBranchInstruction(284, lastBi.offset, lineNumber, 1, branchInstructions, lastBi.branch);
    }

    private static void AnalyzeLastTestBlock(List<Instruction> branchInstructions) {
        int length = branchInstructions.size();
        if (length > 1) {
            --length;
            BranchInstruction branchInstruction = (BranchInstruction)branchInstructions.get(0);
            int firstJumpOffset = branchInstruction.GetJumpOffset();
            int i = 1;
            while (i < length) {
                branchInstruction = (ConditionalBranchInstruction)branchInstructions.get(i);
                int jumpOffset = branchInstruction.GetJumpOffset();
                if (firstJumpOffset != jumpOffset) {
                    BranchInstruction subLastBi = branchInstruction;
                    ArrayList<Instruction> subJumpInstructions = new ArrayList<Instruction>(length);
                    subJumpInstructions.add(branchInstruction);
                    ++i;
                    while (i <= length) {
                        subLastBi = (BranchInstruction)branchInstructions.remove(i);
                        subJumpInstructions.add(subLastBi);
                        --length;
                    }
                    ComparisonInstructionAnalyzer.AnalyzeLastTestBlock(subJumpInstructions);
                    int lineNumber = branchInstructions.get((int)0).lineNumber;
                    branchInstructions.set(--i, new ComplexConditionalBranchInstruction(284, subLastBi.offset, lineNumber, 1, subJumpInstructions, subLastBi.branch));
                }
                ++i;
            }
        }
    }

    private static void SetOperator(ComplexConditionalBranchInstruction cbl, BranchInstruction lastBi, boolean inverse) {
        List<Instruction> instructions = cbl.instructions;
        int lastIndex = instructions.size() - 1;
        BranchInstruction firstBi = (BranchInstruction)instructions.get(0);
        if (firstBi.GetJumpOffset() == lastBi.GetJumpOffset()) {
            cbl.cmp = inverse ? 0 : 2;
            int i = 0;
            while (i <= lastIndex) {
                ComparisonInstructionAnalyzer.SetOperator(instructions.get(i), inverse);
                ++i;
            }
        } else {
            cbl.cmp = inverse ? 2 : 0;
            boolean tmpInverse = !inverse;
            int i = 0;
            while (i < lastIndex) {
                ComparisonInstructionAnalyzer.SetOperator(instructions.get(i++), tmpInverse);
            }
            ComparisonInstructionAnalyzer.SetOperator(instructions.get(i), inverse);
        }
    }

    private static void SetOperator(Instruction instruction, boolean inverse) {
        switch (instruction.opcode) {
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                ComparisonInstructionAnalyzer.SetOperator(to.value1, inverse);
                ComparisonInstructionAnalyzer.SetOperator(to.value2, inverse);
                break;
            }
            case 284: {
                ComplexConditionalBranchInstruction cbl = (ComplexConditionalBranchInstruction)instruction;
                int length = cbl.instructions.size();
                if (length == 1) {
                    ComparisonInstructionAnalyzer.SetOperator(cbl.instructions.get(0), inverse);
                    break;
                }
                if (length <= 1) break;
                ComparisonInstructionAnalyzer.SetOperator(cbl, (BranchInstruction)cbl.instructions.get(length - 1), inverse);
                break;
            }
            default: {
                if (!inverse) break;
                ConditionalBranchInstruction cbi = (ConditionalBranchInstruction)instruction;
                cbi.cmp = 7 - cbi.cmp;
            }
        }
    }

    public static void InverseComparison(Instruction instruction) {
        switch (instruction.opcode) {
            case 260: 
            case 261: 
            case 262: {
                ConditionalBranchInstruction cbi = (ConditionalBranchInstruction)instruction;
                cbi.cmp = 7 - cbi.cmp;
                break;
            }
            case 284: {
                ComplexConditionalBranchInstruction ccbi = (ComplexConditionalBranchInstruction)instruction;
                ccbi.cmp = 2 - ccbi.cmp;
                int i = ccbi.instructions.size() - 1;
                while (i >= 0) {
                    ComparisonInstructionAnalyzer.InverseComparison(ccbi.instructions.get(i));
                    --i;
                }
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                ComparisonInstructionAnalyzer.InverseComparison(to.value1);
                ComparisonInstructionAnalyzer.InverseComparison(to.value2);
            }
        }
    }

    public static int GetLastIndex(List<Instruction> list, int firstIndex) {
        int lenght = list.size();
        int index = firstIndex + 1;
        while (index < lenght) {
            Instruction instruction = list.get(index);
            int opcode = instruction.opcode;
            if (opcode != 260 && opcode != 261 && opcode != 262 && opcode != 167) break;
            ++index;
        }
        if (index - 1 == firstIndex) {
            return firstIndex;
        }
        boolean[] dummy = new boolean[list.get((int)(lenght - 1)).offset];
        while (--index > firstIndex) {
            BranchInstruction lastBi = (BranchInstruction)list.get(index);
            int afterOffest = index + 1 < lenght ? list.get((int)(index + 1)).offset : -1;
            int firstIndexTmp = ComparisonInstructionAnalyzer.SearchFirstIndex(list, index, lastBi, afterOffest, dummy, dummy);
            if (firstIndex == (firstIndexTmp = ComparisonInstructionAnalyzer.ReduceFirstIndex(list, firstIndexTmp, index))) break;
        }
        return index;
    }
}

