/*
 * Copyright (c) 2000-2006 JetBrains s.r.o. All Rights Reserved.
 */

package com.intellij.testFramework.fixtures.impl;

import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.testFramework.fixtures.WebModuleTestFixture;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import org.jetbrains.annotations.NonNls;

import java.util.Collection;

/**
 * @author Dmitry Avdeev
 */
public class WebModuleTestFixtureImpl extends ModuleFixtureImpl implements WebModuleTestFixture {

  public WebModuleTestFixtureImpl(final ModuleFixtureBuilderImpl builder) {
    super(builder);
  }

  @Override
  public void setWebXml(@NonNls final String webXmlPath) {
    assert myBuilder.myContentRoots.size() > 0: "no content roots set";
    final WebFacet webFacet = getWebFacet();
    final ConfigFileInfoSet descriptorsConfiguration = webFacet.getDescriptorsContainer().getConfiguration();
    final String url = VfsUtil.pathToUrl(FileUtil.toSystemIndependentName(myBuilder.myContentRoots.get(0) + webXmlPath));
    descriptorsConfiguration.replaceConfigFile(DeploymentDescriptorsConstants.WEB_XML_META_DATA, url);
  }

  @Override
  public WebFacet getWebFacet() {
    final Collection<WebFacet> facets = WebFacet.getInstances(getModule());
    assert facets.size() == 1;
    return facets.iterator().next();
  }
}
