/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.web;

import org.jetbrains.annotations.NonNls;

/**
 * @since 14
 */
public final class WebCommonClassNames {

  @NonNls public static final String SERVLET = "javax.servlet.Servlet";
  @NonNls public static final String SERVLET_CONTEXT = "javax.servlet.ServletContext";
  @NonNls public static final String SERVLET_CONFIG = "javax.servlet.ServletConfig";
  @NonNls public static final String SERVLET_EXCEPTION = "javax.servlet.ServletException";
  @NonNls public static final String SERVLET_FILTER = "javax.servlet.Filter";
  @NonNls public static final String SERVLET_LISTENER = "javax.servlet.Listener";

  @NonNls public static final String HTTP_COOKIE = "javax.servlet.http.Cookie";
  @NonNls public static final String HTTP_PUSH_PUBLISHER = "javax.servlet.http.PushBuilder";
  @NonNls public static final String HTTP_SESSION = "javax.servlet.http.HttpSession";
  @NonNls public static final String HTTP_SERVLET_REQUEST = "javax.servlet.http.HttpServletRequest";
  @NonNls public static final String HTTP_SERVLET_RESPONSE = "javax.servlet.http.HttpServletResponse";

  @NonNls public static final String ANNOTATION_INIT_PARAM = "javax.servlet.annotation.InitParam";
  @NonNls public static final String ANNOTATION_WEB_FILTER = "javax.servlet.annotation.WebFilter";
  @NonNls public static final String ANNOTATION_WEB_LISTENER = "javax.servlet.annotation.WebListener";
  @NonNls public static final String ANNOTATION_WEB_SERVLET = "javax.servlet.annotation.WebServlet";
}
