/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.ui;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ElementPresentationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author peter
*/
public abstract class NewElementWrapper<T extends DomElement> implements DialogElementWrapper<T> {
  private final T myElement;

  protected NewElementWrapper(@NotNull final Project project, final Class<? extends T> elementClass, @Nullable final JavaeeFacet facet) {
    myElement = WriteCommandAction.writeCommandAction(project).compute(() -> createElement(project, elementClass, facet));
  }

  protected T createElement(@NotNull Project project, final Class<? extends T> elementClass, @Nullable JavaeeFacet facet) {
    Module module = facet == null? null : facet.getModule();
    T t = DomManager.getDomManager(project).createMockElement(elementClass, module, false);
    if (facet != null) {
      JavaeeFacetUtil.getInstance().setFacetForMockElement(t, facet);
    }
    initMockElement(t);
    return t;
  }

  protected void initMockElement(T t) {
  }

  @Override
  public final T getElement() {
    return myElement;
  }

  protected abstract T createRealElement();

  @Override
  public T save() {
    final T t = createRealElement();
    t.copyFrom(myElement);
    return t;
  }

  @Override
  public String getDialogTitle() {
    return J2EEBundle.message("dialog.title.create.new.0", ElementPresentationManager.getTypeNameForObject(getElement()));
  }
}
