package com.intellij.javaee.supportProvider;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author nik
 */
public interface JavaeeFrameworkSupportContributionModel {
  @NotNull
  Project getProject();
  @NotNull
  Module getModule();
  @NotNull
  ModifiableRootModel getRootModel();

  @Nullable
  ModifiableArtifact getModifiableExplodedWarArtifact();
  @Nullable
  ModifiableArtifact getModifiableExplodedEjbArtifact();
  @Nullable
  ModifiableArtifact getModifiableExplodedEarArtifact();

  @Nullable
  CommonModel getRunConfiguration();

  @Nullable
  <F extends Facet> F getFacet(FacetTypeId<F> id);

  @Nullable
  Artifact getExplodedWarArtifact();

  @Nullable
  Artifact getExplodedEarArtifact();

  @Nullable
  Artifact getExplodedEjbArtifact();

  boolean isFrameworkSelected(@NotNull @NonNls String providerId);

  boolean isFacetFrameworkSelected(@NotNull @NonNls FacetTypeId<?> typeId);

  @Nullable 
  VirtualFile getIndexJspFile();
}
