/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.intellij.javaee.model.jam;

import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.GenericValue;

import java.util.List;

/**
 * @author Dmitry Avdeev
 */
public class JamServletMapping implements CommonServletMapping {

  private final JamServlet myServlet;

  public JamServletMapping(JamServlet servlet) {
    myServlet = servlet;
  }

  @Override
  public CommonServlet getServlet() {
    return myServlet;
  }

  @Override
  public List<? extends GenericValue<String>> getUrlPatterns() {
    return myServlet.getUrlPatterns();
  }

  @Override
  public PsiElement getMappingElement() {
    return null;
  }
}
