/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.ejb;

import com.intellij.facet.FacetFinder;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author peter
 */
//todo[nik] rename to EjbFacetUtil?
public class EjbModuleUtil {
  @Nullable
  public static EjbFacet getEjbFacet(@NotNull PsiElement psiElement) {
    return JavaeeFacetUtil.getInstance().getJavaeeFacet(psiElement, EjbFacet.ID);
  }

  @Nullable
  public static EjbFacet getEjbFacet(JavaeeModelElement element) {
    return JavaeeFacetUtil.getInstance().getJavaeeFacet(element, EjbFacet.ID);
  }

  public static EjbRootElement[] getEjbModels(Project project) {
    final Collection<EjbFacet> ejbFacets = JavaeeFacetUtil.getInstance().getJavaeeFacets(EjbFacet.ID, project);
    List<EjbRootElement> list = new ArrayList<>();
    for (EjbFacet ejbFacet : ejbFacets) {
      list.add(ejbFacet.getMergedRoot());
    }
    return list.toArray(new EjbRootElement[0]);
  }

  public static EnterpriseBean findEjbByName(@Nullable EjbFacet ejbFacet, final @Nullable String name) {
    if (ejbFacet == null || name == null) return null;

    final Condition<EnterpriseBean> condition = object -> name.equals(object.getEjbName().getValue());
    final EnterpriseBeanSet beans = ejbFacet.getMergedRoot().getEnterpriseBeans();
    EnterpriseBean result = ContainerUtil.find(beans.getEntities(), condition);
    if (result != null) return result;
    result = ContainerUtil.find(beans.getSessions(), condition);
    if (result != null) return result;
    result = ContainerUtil.find(beans.getMessageDrivens(), condition);
    return result;
  }

  @Nullable
  public static EjbFacet getEjbFacet(final Project project, final VirtualFile file) {
    return FacetFinder.getInstance(project).findFacet(file, EjbFacet.ID);
  }
}
