/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.application.facet;

import com.intellij.facet.*;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.openapi.module.Module;
import com.intellij.util.descriptors.ConfigFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

/**
 * @author nik
 */
public abstract class JavaeeApplicationFacet extends JavaeeFacet {
  public static final FacetTypeId<JavaeeApplicationFacet> ID = new FacetTypeId<>("javaeeApplication");
                       
  protected JavaeeApplicationFacet(@NotNull final FacetType facetType, @NotNull final Module module, final String name,
                                   @NotNull final FacetConfiguration configuration, final Facet underlyingFacet) {
    super(facetType, module, name, configuration, underlyingFacet);
  }

  public static Collection<JavaeeApplicationFacet> getInstances(@NotNull Module module) {
    return FacetManager.getInstance(module).getFacetsByType(ID);
  }

  @Nullable
  public abstract JavaeeApplication getRoot();

  @Nullable
  public abstract ConfigFile getApplicationDescriptor();
}
