// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SpringBootEndpointsTabSettings {
  Topic<Listener> TOPIC = new Topic<>("Spring Boot Endpoints tab settings", Listener.class);

  static SpringBootEndpointsTabSettings getInstance(Project project) {
    return ServiceManager.getService(project, SpringBootEndpointsTabSettings.class);
  }

  void fireSettingsChanged(@NotNull String changeType);

  @Nullable
  String getSelectedTab();

  void setSelectedTab(@Nullable String selectedTab);

  interface Listener {
    void settingsChanged(@NotNull String changeType);
  }
}
