/*
 * Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions;

public class ConditionOutcome {

  private final boolean myMatch;

  private final ConditionMessage myMessage;

  private ConditionOutcome(boolean match, ConditionMessage message) {
    myMatch = match;
    myMessage = message;
  }

  public boolean isMatch() {
    return myMatch;
  }

  public ConditionMessage getMessage() {
    return myMessage;
  }

  public static ConditionOutcome match(String message) {
    return match(new ConditionMessage(message));
  }

  public static ConditionOutcome match(ConditionMessage message) {
    return new ConditionOutcome(true, message);
  }

  public static ConditionOutcome noMatch(String message) {
    return noMatch(new ConditionMessage(message));
  }

  public static ConditionOutcome noMatch(ConditionMessage message) {
    return new ConditionOutcome(false, message);
  }
}
