// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.spring.facet.SpringFileSet;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * Provides additional auto-detected Spring Boot file sets (e.g. bootstrap files set containing bootstrap configurations).
 *
 * @since 2017.3
 * @author Konstantin Aleev
 */
public interface SpringBootModelExtender {
  ExtensionPointName<SpringBootModelExtender> EP_NAME = ExtensionPointName.create("com.intellij.spring.boot.modelExtender");

  @NotNull
  List<SpringFileSet> getAdditionalFileSets(SpringFileSet springBootFileSet);
}
