// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.application.config.keyPath;

import com.intellij.psi.PsiReference;

/**
 * Enum/bean property "extended" path.
 */
public interface ConfigKeyPathReference extends PsiReference {

  PathType getPathType();

  enum PathType {
    ENUM,
    BEAN_PROPERTY,
    ARBITRARY_ENTRY_KEY
  }
}
