// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.application.config.hints;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.boot.application.config.SpringBootConfigFileAnnotatorBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HintReferenceBase extends PsiReferenceBase<PsiElement> implements EmptyResolveMessageProvider {

  @NonNls
  public static final String PLACEHOLDER_PREFIX = "${";
  @NonNls
  public static final String PLACEHOLDER_SUFFIX = "}";

  protected HintReferenceBase(@NotNull PsiElement element, TextRange rangeInElement) {
    super(element, rangeInElement);
  }

  @Nullable
  protected abstract PsiElement doResolve();

  /**
   * @return Highlighting attribute key if value should have special highlighting.
   * @see SpringBootConfigFileAnnotatorBase
   * @since 2017.3
   */
  @Nullable
  public TextAttributesKey getTextAttributesKey() {
    return null;
  }

  @Nullable
  @Override
  public final PsiElement resolve() {
    final String value = getValue();
    if (StringUtil.contains(value, PLACEHOLDER_PREFIX)) {
      return getElement();
    }

    return doResolve();
  }

  @NotNull
  @Override
  public String getUnresolvedMessagePattern() {
    return "Invalid value ''{0}''";
  }
}
