// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.profiles;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.spring.SpringApiBundle;
import com.intellij.util.IncorrectOperationException;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

/**
 * @since 14.1
 */
public class SpringProfile extends RenameableFakePsiElement {

  private String myProfileName;

  public SpringProfile(@NotNull final String profileName,
                       final PsiElement definition) {
    super(definition);
    myProfileName = profileName;
  }

  @NotNull
  @Override
  public PsiElement getNavigationElement() {
    return getParent(); // definition element
  }

  @Override
  @NotNull
  public String getName() {
    return myProfileName;
  }

  @Override
  public String getTypeName() {
    return SpringApiBundle.message("profile.type.name");
  }

  @Override
  public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
    final PsiElement res = super.setName(name);
    myProfileName = name;
    return res;
  }

  @Override
  public Icon getIcon() {
    return SpringApiIcons.SpringProfile;
  }
}