// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.values.converters.resources;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import org.jetbrains.annotations.NotNull;

public class ResourceTypeCondition implements Condition<PsiFileSystemItem> {
  private final String[] myFileExtensions;

  public ResourceTypeCondition(@NotNull String... fileExtensions) {
    myFileExtensions = fileExtensions;
  }

  @Override
  public boolean value(PsiFileSystemItem psiFileSystemItem) {
    for (String fileExtension : myFileExtensions) {
      if (hasExtension(psiFileSystemItem, fileExtension)) return true;
    }
    return false;
  }

  private static boolean hasExtension(PsiFileSystemItem psiFileSystemItem, String fileExtension) {
    if (FileReferenceSet.DIRECTORY_FILTER.value(psiFileSystemItem)) return true;
    VirtualFile virtualFile = psiFileSystemItem.getVirtualFile();

    return virtualFile != null && fileExtension.equals(virtualFile.getExtension());
  }

  @NotNull
  public String[] getExpectedExtensions() {
    return myFileExtensions;
  }
}
