// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package com.intellij.spring.model.converters;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.util.xml.ConvertContext;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

public class LookupMethodBeanConverter extends SpringBeanResolveConverter {

  @Override
  @NotNull
  public List<PsiClassType> getRequiredClasses(final ConvertContext context) {
    final LookupMethod lookupMethod = (LookupMethod)context.getInvocationElement().getParent();
    assert lookupMethod != null;
    final PsiMethod psiMethod = lookupMethod.getName().getValue();
    if (psiMethod != null) {
      final PsiType returnType = psiMethod.getReturnType();
      if (returnType instanceof PsiClassType) {
        return Collections.singletonList((PsiClassType)returnType);
      }
    }
    return Collections.emptyList();
  }
}