// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.actions.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.actions.generate.AbstractDomGenerateProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BasicSpringDomGenerateProvider<T extends DomElement> extends AbstractDomGenerateProvider<T> {

  protected BasicSpringDomGenerateProvider(final String description, final Class<T> tClass, @Nullable final String mappingId) {
    super(description, tClass, mappingId);
  }

  @Override
  protected DomElement getParentDomElement(final Project project, final Editor editor, final PsiFile file) {
    DomFileElement<Beans> domFileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)file);
    return domFileElement == null ? null : domFileElement.getRootElement();
  }
}
