/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.facet;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.constants.SpringConstants;
import org.jetbrains.annotations.NonNls;

/**
 * @author Dmitry Avdeev
 */
public enum SpringSchemaVersion {

  SPRING_1_DTD(SpringApiBundle.message("create.spring.context.file.dtd.1.0"),
               SpringConstants.BEANS_DTD_1,
               "spring-beans.1_0.xml"),
  SPRING_2_DTD(SpringApiBundle.message("create.spring.context.file.dtd.2.0"),
               SpringConstants.BEANS_DTD_2,
               "spring-beans.2_0.xml"),
  SPRING_SCHEMA(SpringApiBundle.message("create.spring.context.file.schema.2.0"),
                SpringConstants.BEANS_XSD,
                "spring-beans.schema.xml");

  private final String myName;
  private final String myNamespace;
  private final String myTemplateName;

  SpringSchemaVersion(String name, @NonNls String namespace, @NonNls String templateName) {
    myName = name;
    myNamespace = namespace;
    myTemplateName = templateName;
  }

  public String getName() {
    return myName;
  }

  public String getTemplateName() {
    return myTemplateName;
  }

  public FileTemplate getTemplate(Project project) {
    return FileTemplateManager.getInstance(project).getJ2eeTemplate(myTemplateName);
  }

  public String getNamespace() {
    return myNamespace;
  }

  public String toString() {
    return getName();
  }
}
