/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.facet;

import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.ide.projectWizard.ModuleTypeCategory;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

/**
 * @author Dmitry Avdeev
 */
public class SpringProjectCategory extends ModuleTypeCategory.Java {

  public static final FrameworkRole ROLE = new FrameworkRole(SpringFacet.FACET_TYPE_ID.toString());

  @Override
  public String getId() {
    return SpringFacet.FACET_TYPE_ID.toString();
  }

  @Override
  public String getDisplayName() {
    return "Spring";
  }

  @Override
  public Icon getIcon() {
    return SpringApiIcons.Spring;
  }

  @Override
  public String getDescription() {
    return null;
  }

  @NotNull
  @Override
  public String[] getPreselectedFrameworkIds() {
    return new String[] { FacetBasedFrameworkSupportProvider.getProviderId(SpringFacet.FACET_TYPE_ID) };
  }

  @Override
  public FrameworkRole[] getAcceptableFrameworkRoles() {
    return new FrameworkRole[] {ROLE};
  }
}
