/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.util.PairProcessor;

/**
 * Provides additional models defined on local annotation model, e.g. {@code @EnableXYZ} implicit models.
 *
 * @since 15
 */
public abstract class LocalAnnotationModelDependentModelsProvider {

  public static final ExtensionPointName<LocalAnnotationModelDependentModelsProvider> EP_NAME =
    ExtensionPointName.create("com.intellij.spring.localAnnotationModelDependentModelsProvider");

  /**
   * @param localAnnotationModel Current local annotation model.
   * @param processor            Processor instance to pass additional models to.
   * @return {@code processor.process(additionalModel, additionalModelDependency)}, {@code false} to stop processing.
   */
  public abstract boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel,
                                                            PairProcessor<? super LocalModel, ? super LocalModelDependency> processor);
}
