/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.model.bootstrap;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.cloud.library.SpringCloudLibraryUtil;
import com.intellij.spring.boot.cloud.model.bootstrap.SpringBootBootstrapFileSet;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelExtender;
import com.intellij.spring.boot.model.autoconfigure.SpringOrderClassSorter;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SpringBootBootstrapModelExtender
implements SpringBootModelExtender {
    SpringBootBootstrapModelExtender() {
    }

    @NotNull
    public List<SpringFileSet> getAdditionalFileSets(SpringFileSet springBootFileSet) {
        SpringFacet facet = springBootFileSet.getFacet();
        Module module = facet.getModule();
        if (!SpringCloudLibraryUtil.hasSpringCloudCommons(module)) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                SpringBootBootstrapModelExtender.$$$reportNull$$$0(0);
            }
            return list;
        }
        List bootstrapConfigs = SpringSpiManager.getInstance((Module)module).getClassesListValue(false, "org.springframework.cloud.bootstrap.BootstrapConfiguration");
        SpringOrderClassSorter sorter = new SpringOrderClassSorter(new ArrayList(new LinkedHashSet(bootstrapConfigs)));
        SpringBootBootstrapFileSet bootstrapFileSet = new SpringBootBootstrapFileSet(springBootFileSet, facet);
        ((SpringFacetConfiguration)facet.getConfiguration()).registerAutodetectedFileSet((SpringFileSet)bootstrapFileSet);
        sorter.getSortedConfigs().forEach(arg_0 -> SpringBootBootstrapModelExtender.lambda$getAdditionalFileSets$0((SpringFileSet)bootstrapFileSet, arg_0));
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file : contributor.getConfigurationFiles(module, (SpringFileSet)bootstrapFileSet, false)) {
                bootstrapFileSet.addFile(file);
            }
        }
        springBootFileSet.addDependency((SpringFileSet)bootstrapFileSet);
        List list = ContainerUtil.newSmartList((Object)((Object)bootstrapFileSet));
        if (list == null) {
            SpringBootBootstrapModelExtender.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void lambda$getAdditionalFileSets$0(SpringFileSet bootstrapFileSet, PsiClass psiClass) {
        bootstrapFileSet.addFile(psiClass.getContainingFile().getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/cloud/model/bootstrap/SpringBootBootstrapModelExtender", "getAdditionalFileSets"));
    }
}

