/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.model.bootstrap;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.cloud.SpringCloudBundle;
import com.intellij.spring.boot.cloud.library.SpringCloudLibraryUtil;
import com.intellij.spring.boot.cloud.model.bootstrap.SpringBootBootstrapFileSet;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;

public class SpringBootBootstrapConfigurationInspection
extends SpringUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement nameIdentifier;
        if (uClass == null) {
            SpringBootBootstrapConfigurationInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringBootBootstrapConfigurationInspection.$$$reportNull$$$0(1);
        }
        if ((nameIdentifier = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor())) == null) {
            return null;
        }
        PsiClass psiClass = uClass.getJavaPsi();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return null;
        }
        if (!SpringCloudLibraryUtil.hasSpringCloudCommons(module) || !SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass)) {
            return null;
        }
        SpringBootBootstrapFileSet bootstrapFileSet = SpringBootBootstrapConfigurationInspection.findBootstrapFileSet(springFacet, psiClass.getContainingFile().getVirtualFile());
        if (bootstrapFileSet == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        PairProcessor findFirstProcessor = (property, propertyClass) -> !psiManager.areElementsEquivalent((PsiElement)propertyClass, (PsiElement)psiClass);
        if (SpringSpiManager.getInstance((Module)module).processClassesListValues(false, uClass.getQualifiedName(), findFirstProcessor)) {
            return null;
        }
        Set models = SpringManager.getInstance((Project)module.getProject()).getAllModelsWithoutDependencies(module);
        for (SpringModel model : models) {
            SpringFileSet fileSet = model.getFileSet();
            if (fileSet == null || !fileSet.getDependencyFileSets().contains((Object)bootstrapFileSet)) continue;
            for (CommonSpringModel commonSpringModel : model.getRelatedModels()) {
                SpringFileSet modelFileSet;
                if (commonSpringModel instanceof SpringModel && (modelFileSet = ((SpringModel)commonSpringModel).getFileSet()) != null && bootstrapFileSet.getId().equals(modelFileSet.getId())) continue;
                CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
                commonSpringModel.processByClass(SpringModelSearchParameters.byClass((PsiClass)psiClass), (Processor)processor);
                if (!processor.isFound()) continue;
                ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
                holder.registerProblem(nameIdentifier, SpringCloudBundle.message("spring.cloud.bootstrap.configuration.component.scanned", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                return holder.getResultsArray();
            }
        }
        return null;
    }

    @Nullable
    private static SpringBootBootstrapFileSet findBootstrapFileSet(SpringFacet springFacet, VirtualFile file) {
        for (SpringFileSet fileSet : SpringFileSetService.getInstance().getModelProviderSets(springFacet)) {
            if (!(fileSet instanceof SpringBootBootstrapFileSet) || !fileSet.hasFile(file)) continue;
            return (SpringBootBootstrapFileSet)fileSet;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "uClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/cloud/model/bootstrap/SpringBootBootstrapConfigurationInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

