/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringDomInspectionUtils;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowExecutionListener;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowExecutionListeners;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowExecutor;
import com.intellij.spring.webflow.model.WebflowVersion;
import com.intellij.spring.webflow.model.converters.BeanImportResourceConverter;
import com.intellij.spring.webflow.model.converters.ParentStateReference;
import com.intellij.spring.webflow.model.xml.Action;
import com.intellij.spring.webflow.model.xml.ActionState;
import com.intellij.spring.webflow.model.xml.BeanAction;
import com.intellij.spring.webflow.model.xml.BeanImport;
import com.intellij.spring.webflow.model.xml.DecisionState;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.model.xml.If;
import com.intellij.spring.webflow.model.xml.Secured;
import com.intellij.spring.webflow.model.xml.SubflowState;
import com.intellij.spring.webflow.model.xml.Transition;
import com.intellij.spring.webflow.model.xml.Var;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.spring.webflow.util.WebflowVersionDetector;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class WebflowModelVisitor
implements DomElementVisitor {
    private final DomElementAnnotationHolder myHolder;
    private final SpringDomInspectionUtils mySpringDomInspectionUtils;
    private Boolean foundSecurityFlowExecutor = null;

    WebflowModelVisitor(DomElementAnnotationHolder holder) {
        this.myHolder = holder;
        this.mySpringDomInspectionUtils = new SpringDomInspectionUtils(holder);
    }

    public void visitDomElement(DomElement element) {
    }

    public void visitSubflowState(SubflowState subflowState) {
        Module module;
        if (SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{subflowState.getSubflow(), subflowState.getFlow()})) {
            return;
        }
        if (DomUtil.hasXml((DomElement)subflowState.getParentAction())) {
            PsiReference[] references;
            XmlAttributeValue xmlAttributeValue = subflowState.getParentAction().getXmlAttributeValue();
            assert (xmlAttributeValue != null);
            for (PsiReference reference : references = xmlAttributeValue.getReferences()) {
                ParentStateReference parentStateReference;
                Identified identified;
                if (!(reference instanceof ParentStateReference) || (identified = (parentStateReference = (ParentStateReference)reference).getIdentified()) == null || !DomUtil.hasXml(((SubflowState)identified).getSubflow())) continue;
                return;
            }
        }
        if ((module = subflowState.getModule()) == null) {
            return;
        }
        WebflowVersion detect = WebflowVersionDetector.detect(module);
        if (detect.isAtLeast(WebflowVersion.Webflow_2_0)) {
            if (this.myHolder.isOnTheFly()) {
                this.myHolder.createProblem((DomElement)subflowState, WebflowBundle.message("model.inspection.subflow.state.attribute.subflow.required", new Object[0]), new LocalQuickFix[]{new InsertRequiredAttributeFix(subflowState.getXmlTag(), "subflow", new String[0])});
            } else {
                this.myHolder.createProblem((DomElement)subflowState, WebflowBundle.message("model.inspection.subflow.state.attribute.subflow.required", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    public void visitDecisionState(DecisionState decisionState) {
        List<If> ifs = decisionState.getIfs();
        if (ifs.size() <= 1) {
            return;
        }
        If firstIf = ifs.get(0);
        if (DomUtil.hasXml(firstIf.getElse())) {
            this.myHolder.createProblem((DomElement)firstIf, WebflowBundle.message("model.inspection.decision.state.first.if.with.else.disables.other.ifs", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public void visitTransition(Transition transition) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)transition, new GenericAttributeValue[]{transition.getOn(), transition.getOnException()});
    }

    public void visitSecured(Secured secured) {
        Transition transition = (Transition)secured.getParentOfType(Transition.class, true);
        if (transition != null && DomUtil.hasXml(transition.getOnException())) {
            this.myHolder.createProblem((DomElement)secured, WebflowBundle.message("model.inspection.secured.not.for.transition.with.on.exception", new Object[0]), new LocalQuickFix[0]);
        }
        if (this.foundSecurityFlowExecutor == null) {
            this.foundSecurityFlowExecutor = WebflowModelVisitor.isSecurityFlowExecutionListenerDefined(secured);
        }
        if (!this.foundSecurityFlowExecutor.booleanValue()) {
            this.myHolder.createProblem((DomElement)secured, "No <listener> of type 'org.springframework.webflow.security.SecurityFlowExecutionListener' configured", new LocalQuickFix[0]);
        }
    }

    public void visitVar(Var var) {
        CommonSpringBean bean;
        SpringBeanPointer pointer = (SpringBeanPointer)var.getBean().getValue();
        if (pointer != null && (bean = pointer.getSpringBean()).isValid() && !WebflowUtil.isNonSingletonPrototype(bean)) {
            this.myHolder.createProblem(var.getBean(), WebflowBundle.message("model.inspection.var.bean.must.be.non.singleton.prototype", new Object[0]), new LocalQuickFix[0]);
        }
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)var, new GenericAttributeValue[]{var.getBean(), var.getClazz()});
    }

    public void visitBeanImport(BeanImport beanImport) {
        PsiFileSystemItem value = (PsiFileSystemItem)beanImport.getResource().getValue();
        if (value == null) {
            return;
        }
        if (!BeanImportResourceConverter.SPRING_XML_CONDITION.value((Object)value)) {
            this.myHolder.createProblem(beanImport.getResource(), WebflowBundle.message("model.inspection.bean.import.not.spring.xml", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        VirtualFile virtualFile = value.getVirtualFile();
        Module module = beanImport.getModule();
        if (module == null) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
        if (psiFile == null) {
            return;
        }
        for (SpringModel model : SpringManager.getInstance((Project)beanImport.getManager().getProject()).getAllModels(module)) {
            SpringFileSet set;
            if (!(model instanceof XmlSpringModel) || (set = model.getFileSet()) == null || !SpringModelVisitorUtils.hasConfigFile((CommonSpringModel)model, (PsiFile)psiFile)) continue;
            return;
        }
        this.myHolder.createProblem(beanImport.getResource(), WebflowBundle.message("model.inspection.bean.import.spring.xml.not.in.context", new Object[0]), new LocalQuickFix[0]);
    }

    public void visitAction(Action action) {
        this.checkActionMethodSignature(action.getMethod());
        this.checkMultiActionInconsistency(action);
        this.checkActionMethodIsPublic(action.getMethod());
    }

    public void visitBeanAction(BeanAction beanAction) {
        this.checkActionMethodIsPublic(beanAction.getMethod());
    }

    private static boolean isMultiActionBean(@Nullable GenericAttributeValue<SpringBeanPointer> value) {
        return WebflowModelVisitor.isBeanOfSpecificType(value, "org.springframework.webflow.action.MultiAction");
    }

    private void checkMultiActionInconsistency(Action action) {
        PsiClass beanClass;
        PsiMethod actionMethod;
        String defaultMethodName;
        ActionState actionState;
        PsiMethod method;
        if (WebflowModelVisitor.isMultiActionBean(action.getBean()) && (method = (PsiMethod)action.getMethod().getValue()) == null && (actionState = (ActionState)action.getParentOfType(ActionState.class, false)) != null && (defaultMethodName = (String)actionState.getId().getValue()) != null && (actionMethod = WebflowModelVisitor.findMultiActionMethod(beanClass = WebflowModelVisitor.getBeanClass(action.getBean()), defaultMethodName)) == null) {
            this.myHolder.createProblem((DomElement)action, HighlightSeverity.ERROR, WebflowBundle.message("model.inspection.multi.action.bean.method.not.specified", new Object[0]), new LocalQuickFix[]{new DefineAttributeQuickFix("method")});
        }
    }

    @Nullable
    private static PsiMethod findMultiActionMethod(PsiClass beanClass, String methodName) {
        if (beanClass != null) {
            for (PsiMethod method : beanClass.getAllMethods()) {
                if (!method.getName().equals(methodName) || !method.hasModifierProperty("public") || method.getParameterList().getParametersCount() != 1 || !WebflowModelVisitor.isAssignable("org.springframework.webflow.execution.RequestContext", method.getParameterList().getParameters()[0].getType(), method.getProject()) || !WebflowModelVisitor.isAssignable("org.springframework.webflow.execution.Event", method.getReturnType(), method.getProject())) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean isAssignable(String className, PsiType type, Project project) {
        if (type == null) {
            return false;
        }
        if (type.getCanonicalText().equals(className)) {
            return true;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        return psiClass != null && type.isAssignableFrom((PsiType)PsiTypesUtil.getClassType((PsiClass)psiClass));
    }

    private static boolean isBeanOfSpecificType(GenericAttributeValue<SpringBeanPointer> bean, String className) {
        PsiClass beanClass = WebflowModelVisitor.getBeanClass(bean);
        if (beanClass != null) {
            PsiClass psiClass = DomJavaUtil.findClass((String)className, bean);
            return InheritanceUtil.isInheritorOrSelf((PsiClass)beanClass, (PsiClass)psiClass, (boolean)true);
        }
        return false;
    }

    @Nullable
    private static PsiClass getBeanClass(GenericAttributeValue<SpringBeanPointer> bean) {
        SpringBeanPointer springBeanPointer = (SpringBeanPointer)bean.getValue();
        if (springBeanPointer != null) {
            return springBeanPointer.getBeanClass();
        }
        return null;
    }

    private void checkActionMethodSignature(GenericAttributeValue<PsiMethod> methodValue) {
        PsiMethod method = (PsiMethod)methodValue.getValue();
        if (method != null) {
            PsiType type;
            if (method.getParameterList().getParameters().length != 1 || !WebflowModelVisitor.isAssignable("org.springframework.webflow.execution.RequestContext", method.getParameterList().getParameters()[0].getType(), method.getProject())) {
                this.myHolder.createProblem(methodValue, WebflowBundle.message("model.inspection.action.bean.method.parameter.type", new Object[0]), new LocalQuickFix[0]);
            }
            if ((type = method.getReturnType()) == null || !WebflowModelVisitor.isAssignable("org.springframework.webflow.execution.Event", type, method.getProject())) {
                this.myHolder.createProblem(methodValue, WebflowBundle.message("model.inspection.action.bean.method.return.type", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private void checkActionMethodIsPublic(GenericAttributeValue<PsiMethod> methodValue) {
        PsiMethod method = (PsiMethod)methodValue.getValue();
        if (method == null) {
            return;
        }
        if (!method.hasModifierProperty("public")) {
            this.myHolder.createProblem(methodValue, WebflowBundle.message("model.inspection.action.bean.method.must.be.public", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isSecurityFlowExecutionListenerDefined(DomElement domElement) {
        Module module = domElement.getModule();
        if (module == null) {
            return false;
        }
        PsiClass securityFlowExecutionListener = DomJavaUtil.findClass((String)"org.springframework.webflow.security.SecurityFlowExecutionListener", (DomElement)domElement);
        if (securityFlowExecutionListener == null) {
            return false;
        }
        Set models = SpringManager.getInstance((Project)domElement.getManager().getProject()).getAllModels(module);
        for (SpringModel model : models) {
            if (!(model instanceof XmlSpringModel)) continue;
            Set roots = ((XmlSpringModel)model).getLocalModelsRoots();
            for (DomFileElement domFileElement : roots) {
                if (!SpringDomUtils.hasNamespace((DomFileElement)domFileElement, (String)"Spring Webflow Config namespace key")) continue;
                List flowExecutor = DomUtil.getDefinedChildrenOfType((DomElement)domFileElement, FlowExecutor.class, (boolean)true, (boolean)false);
                for (FlowExecutor executor : flowExecutor) {
                    List<FlowExecutionListeners> listeners = executor.getFlowExecutionListeners();
                    for (FlowExecutionListeners listener : listeners) {
                        for (FlowExecutionListener executionListener : listener.getListeners()) {
                            SpringBeanPointer springBeanPointer = (SpringBeanPointer)executionListener.getRef().getValue();
                            if (springBeanPointer == null || !securityFlowExecutionListener.equals(springBeanPointer.getBeanClass())) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

