/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;

public class SelectFromMavenProjectsDialog
extends DialogWrapper {
    private final SimpleTree myTree;
    private final NodeSelector mySelector;

    public SelectFromMavenProjectsDialog(Project project, String title, Class<? extends MavenProjectsStructure.MavenSimpleNode> nodeClass) {
        this(project, title, nodeClass, null);
    }

    public SelectFromMavenProjectsDialog(Project project, String title, final Class<? extends MavenProjectsStructure.MavenSimpleNode> nodeClass, @Nullable NodeSelector selector) {
        super(project, false);
        this.mySelector = selector;
        this.setTitle(title);
        this.myTree = new SimpleTree();
        this.myTree.getSelectionModel().setSelectionMode(1);
        MavenProjectsStructure treeStructure = new MavenProjectsStructure(project, MavenProjectsManager.getInstance(project), MavenTasksManager.getInstance(project), MavenShortcutsManager.getInstance(project), MavenProjectsNavigator.getInstance(project), this.myTree){

            @Override
            protected Class<? extends MavenProjectsStructure.MavenSimpleNode>[] getVisibleNodesClasses() {
                return new Class[]{nodeClass};
            }

            @Override
            protected boolean showDescriptions() {
                return false;
            }

            @Override
            protected boolean showOnlyBasicPhases() {
                return false;
            }
        };
        treeStructure.update();
        if (this.mySelector != null) {
            final SimpleNode[] selection = new SimpleNode[]{null};
            treeStructure.accept(new SimpleNodeVisitor(){

                public boolean accept(SimpleNode each) {
                    if (!SelectFromMavenProjectsDialog.this.mySelector.shouldSelect(each)) {
                        return false;
                    }
                    selection[0] = each;
                    return true;
                }
            });
            if (selection[0] != null) {
                treeStructure.select(selection[0]);
            }
        }
        this.init();
    }

    protected SimpleNode getSelectedNode() {
        return this.myTree.getNodeFor(this.myTree.getSelectionPath());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        pane.setPreferredSize((Dimension)JBUI.size((int)320, (int)400));
        return pane;
    }

    protected static interface NodeSelector {
        public boolean shouldSelect(SimpleNode var1);
    }
}

