/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.ctl;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.Processor;
import com.vladium.emma.ctl.ControlRequest;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.rt.RTControllerClientProxy;
import com.vladium.emma.rt.rpc.Response;
import com.vladium.logging.Logger;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.util.exception.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;

public final class CtlProcessor
extends Processor
implements IAppErrorCodes {
    private String m_connectionString;
    private ControlRequest[] m_commandSequence = ControlRequest.EMPTY_CONTROL_REQUEST_ARRAY;
    private static final Class[] EXPECTED_FAILURES = new Class[]{class$com$vladium$emma$EMMARuntimeException == null ? (class$com$vladium$emma$EMMARuntimeException = CtlProcessor.class$("com.vladium.emma.EMMARuntimeException")) : class$com$vladium$emma$EMMARuntimeException, class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = CtlProcessor.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = CtlProcessor.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException};
    static /* synthetic */ Class class$com$vladium$emma$EMMARuntimeException;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;
    static /* synthetic */ Class class$java$lang$IllegalStateException;

    public static CtlProcessor create() {
        return new CtlProcessor();
    }

    public final synchronized void setConnectionString(String connection) {
        this.m_connectionString = connection == null || connection.length() == 0 ? null : connection;
    }

    public final synchronized void setCommandSequence(ControlRequest[] sequence) {
        if (sequence == null || sequence.length == 0) {
            this.m_commandSequence = ControlRequest.EMPTY_CONTROL_REQUEST_ARRAY;
        } else {
            sequence = (ControlRequest[])sequence.clone();
            for (int c = 0; c < sequence.length; ++c) {
                if (sequence[c] != null) continue;
                throw new IllegalArgumentException("null input: sequence[" + c + "]");
            }
            this.m_commandSequence = sequence;
        }
    }

    protected void validateState() {
        super.validateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _run(IProperties toolProperties) {
        int port;
        Logger log = this.m_log;
        boolean info = this.m_log.atINFO();
        boolean verbose = this.m_log.atVERBOSE();
        boolean trace1 = this.m_log.atTRACE1();
        String method = "_run";
        if (verbose) {
            log.verbose("[EMMA v0.0, build 0 (unsupported private build) (unknown)]");
            log.verbose("control command sequence:");
            log.verbose("{");
            for (int c = 0; c < this.m_commandSequence.length; ++c) {
                log.verbose("  " + this.m_commandSequence[c]);
            }
            log.verbose("}");
        } else {
            log.info("processing control command sequence ...");
        }
        if (this.m_commandSequence.length == 0) {
            return;
        }
        String _host = null;
        String _port = null;
        if (this.m_connectionString != null) {
            String[] tokens = CtlProcessor.parseConnectionString(this.m_connectionString);
            _host = tokens[0];
            _port = tokens[1];
        }
        if (_host == null) {
            _host = toolProperties.getProperty("rt.control.host", "localhost");
        }
        if (_port == null) {
            _port = toolProperties.getProperty("rt.control.port", Integer.toString(47653));
        }
        try {
            port = Integer.parseInt(_port);
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("control port must be in [1, 65535] range: " + port);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("malformed control port number: " + _port);
        }
        String host = _host;
        RuntimeException failure = null;
        try {
            RTControllerClientProxy proxy;
            if (verbose) {
                log.info("connecting to [" + host + ":" + port + "] ...");
            }
            try {
                proxy = RTControllerClientProxy.create(host, port);
            }
            catch (UnknownHostException nhe) {
                throw new EMMARuntimeException("could not connect to [" + host + "]", nhe);
            }
            for (int c = 0; c < this.m_commandSequence.length; ++c) {
                Response response;
                ControlRequest command = this.m_commandSequence[c];
                String prefix = command.getName() + ": ";
                command.populateDefaultArgs(toolProperties);
                if (verbose) {
                    log.verbose("executing [" + command.getName() + "] with arguments:");
                    log.verbose("{");
                    String[] args = command.getArgs();
                    for (int a = 0; a < args.length; ++a) {
                        log.verbose("  " + (args[a] != null ? args[a] : "<null>"));
                    }
                    log.verbose("}");
                } else {
                    log.info("executing [" + command + "] ...");
                }
                long start = info ? System.currentTimeMillis() : 0L;
                try {
                    response = proxy.execute(command);
                    if (trace1) {
                        long cend = System.currentTimeMillis();
                        log.trace1("_run", prefix + "RPC call completed in " + (cend - start) + " ms");
                    }
                }
                catch (IOException ioe) {
                    throw new EMMARuntimeException(prefix + "RPC failure while executing [" + command.getName() + "]", ioe);
                }
                Serializable data = response.getData();
                if (data instanceof Throwable) {
                    throw new EMMARuntimeException(prefix + "server-side failure:", (Throwable)data);
                }
                String[] args = command.getArgs();
                switch (response.getID()) {
                    case 1: {
                        ICoverageData cdata = (ICoverageData)data;
                        if (cdata == null || cdata.isEmpty()) {
                            log.info(prefix + "no output created (no coverage data has been collected by the server VM yet)");
                            break;
                        }
                        File cdataOutFile = new File(args[0]);
                        boolean cdataOutMerge = Property.toBoolean(args[1]);
                        try {
                            if (verbose) {
                                log.verbose(prefix + "coverage data contains " + cdata.size() + " entries");
                            }
                            long sstart = info ? System.currentTimeMillis() : 0L;
                            DataFactory.persist(cdata, cdataOutFile, cdataOutMerge);
                            if (!log.atINFO()) break;
                            long send = System.currentTimeMillis();
                            log.info(prefix + "local copy of coverage data " + (cdataOutMerge ? "merged into" : "written to") + " [" + cdataOutFile.getAbsolutePath() + "] {in " + (send - sstart) + " ms}");
                            break;
                        }
                        catch (IOException ioe) {
                            throw new EMMARuntimeException("OUT_IO_FAILURE", new Object[]{cdataOutFile.getAbsolutePath()}, ioe);
                        }
                    }
                    case 2: {
                        log.info(prefix + data);
                        break;
                    }
                    case 3: {
                        log.info(prefix + data);
                    }
                }
                if (!info) continue;
                long end = System.currentTimeMillis();
                log.info(prefix + "command completed in " + (end - start) + " ms");
            }
            log.info("control command sequence complete");
        }
        catch (SecurityException se) {
            failure = new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, se);
        }
        catch (RuntimeException re) {
            failure = re;
        }
        finally {
            this.reset();
        }
        if (failure != null) {
            if (Exceptions.unexpectedFailure(failure, EXPECTED_FAILURES)) {
                throw new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{failure.toString(), "this private build is unsupported"}, failure);
            }
            throw failure;
        }
    }

    private CtlProcessor() {
    }

    private void reset() {
    }

    private static String[] parseConnectionString(String s) {
        s = s.trim();
        String host = "";
        String port = "";
        int firstColon = s.indexOf(58);
        if (firstColon < 0) {
            try {
                Integer.parseInt(s);
                port = s;
            }
            catch (NumberFormatException nfe) {
                host = s;
            }
        } else {
            host = s.substring(0, firstColon).trim();
            port = s.substring(firstColon + 1).trim();
        }
        String[] result = new String[]{host.length() != 0 ? host : null, port.length() != 0 ? port : null};
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

