/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.template;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyShortenFQNamesProcessor
implements TemplateOptionalProcessor,
DumbAware {
    public void processText(Project project, Template template, Document document, RangeMarker templateRange, Editor editor) {
        PsiFile file;
        if (!template.isToShortenLongNames()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile psiFile = file = editor instanceof EditorWindow ? ((EditorWindow)editor).getInjectedFile() : PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file instanceof GroovyFile) {
            DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, templateRange.getStartOffset(), templateRange.getEndOffset()));
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
    }

    public String getOptionName() {
        return CodeInsightBundle.message((String)"dialog.edit.template.checkbox.shorten.fq.names", (Object[])new Object[0]);
    }

    public boolean isEnabled(Template template) {
        return template.isToShortenLongNames();
    }

    public boolean isVisible(@NotNull Template template, @NotNull TemplateContext context) {
        if (template == null) {
            GroovyShortenFQNamesProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GroovyShortenFQNamesProcessor.$$$reportNull$$$0(1);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "template";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/template/GroovyShortenFQNamesProcessor";
        objectArray[2] = "isVisible";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

