/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;

public class GroovyValidationUtil {
    private GroovyValidationUtil() {
    }

    public static boolean validateNewParameterName(GrParameter variable, MultiMap<PsiElement, String> conflicts, @NotNull String varName) {
        if (varName == null) {
            GroovyValidationUtil.$$$reportNull$$$0(0);
        }
        GrParameterList list = (GrParameterList)PsiTreeUtil.getParentOfType((PsiElement)variable, GrParameterList.class);
        GrParameterListOwner owner = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)variable, GrParameterListOwner.class);
        assert (owner != null);
        for (GrParameter parameter : list.getParameters()) {
            if (parameter.equals(variable)) continue;
            GroovyValidationUtil.validateVariableOccurrencesDownImpl(parameter, conflicts, varName);
        }
        GroovyValidationUtil.validateVariableOccurrencesDown(owner, list, conflicts, varName);
        PsiElement parent = owner.getParent();
        GroovyValidationUtil.validateVariableOccurrencesUp(parent, owner, conflicts, varName, parent instanceof GroovyFile);
        return conflicts.isEmpty();
    }

    private static void validateVariableOccurrencesUp(PsiElement parent, PsiElement lastParent, MultiMap<PsiElement, String> conflicts, @NotNull String varName, boolean containerIsFile) {
        GrForStatement statement;
        GrForClause clause;
        if (varName == null) {
            GroovyValidationUtil.$$$reportNull$$$0(1);
        }
        if (!containerIsFile && parent instanceof PsiFile || parent == null) {
            return;
        }
        for (PsiElement child = parent.getFirstChild(); child != null && child != lastParent; child = child.getNextSibling()) {
            if (!(child instanceof GrVariableDeclaration)) continue;
            for (GrVariable variable : ((GrVariableDeclaration)child).getVariables()) {
                if (!varName.equals(variable.getName())) continue;
                GroovyValidationUtil.addConflict(varName, (PsiNamedElement)variable, conflicts);
            }
        }
        if (parent instanceof GrParameterListOwner) {
            GrParameterListOwner owner = (GrParameterListOwner)parent;
            for (GrParameter parameter : owner.getParameters()) {
                if (!varName.equals(parameter.getName())) continue;
                GroovyValidationUtil.addConflict(varName, (PsiNamedElement)parameter, conflicts);
            }
        } else if (parent instanceof GrForStatement && (clause = (statement = (GrForStatement)parent).getClause()) != null) {
            for (GrVariable variable : clause.getDeclaredVariables()) {
                if (!varName.equals(variable.getName())) continue;
                GroovyValidationUtil.addConflict(varName, (PsiNamedElement)variable, conflicts);
            }
        }
        if (parent instanceof PsiFile) {
            return;
        }
        GroovyValidationUtil.validateVariableOccurrencesUp(parent.getParent(), parent, conflicts, varName, false);
    }

    private static void validateVariableOccurrencesDown(PsiElement parent, PsiElement startChild, MultiMap<PsiElement, String> conflicts, @NotNull String varName) {
        if (varName == null) {
            GroovyValidationUtil.$$$reportNull$$$0(2);
        }
        for (PsiElement child = parent.getLastChild(); child != null && child != startChild && !(child instanceof GrTypeDefinition); child = child.getPrevSibling()) {
            GroovyValidationUtil.validateVariableOccurrencesDownImpl(child, conflicts, varName);
        }
    }

    private static void validateVariableOccurrencesDownImpl(PsiElement child, MultiMap<PsiElement, String> conflicts, String varName) {
        if (child instanceof PsiNamedElement) {
            PsiNamedElement element = (PsiNamedElement)child;
            if (varName.equals(element.getName())) {
                GroovyValidationUtil.addConflict(varName, element, conflicts);
            } else {
                for (PsiElement psiElement : child.getChildren()) {
                    if (child instanceof GrTypeDefinition) continue;
                    GroovyValidationUtil.validateVariableOccurrencesDownImpl(psiElement, conflicts, varName);
                }
            }
        }
    }

    private static void addConflict(String varName, PsiNamedElement element, MultiMap<PsiElement, String> conflicts) {
        if (element instanceof GrParameter) {
            conflicts.putValue((Object)element, (Object)GroovyRefactoringBundle.message("variable.conflicts.with.parameter.0", CommonRefactoringUtil.htmlEmphasize((String)varName)));
        } else if (element instanceof GrField) {
            conflicts.putValue((Object)element, (Object)GroovyRefactoringBundle.message("variable.conflicts.with.field.0", CommonRefactoringUtil.htmlEmphasize((String)varName)));
        } else {
            conflicts.putValue((Object)element, (Object)GroovyRefactoringBundle.message("variable.conflicts.with.variable.0", CommonRefactoringUtil.htmlEmphasize((String)varName)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "varName";
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/GroovyValidationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateNewParameterName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validateVariableOccurrencesUp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateVariableOccurrencesDown";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ParameterNameSuggester {
        private final String myName;
        private final GrParameter myParameter;

        public ParameterNameSuggester(String name, GrParameter parameter) {
            this.myName = name;
            this.myParameter = parameter;
        }

        public String generateName() {
            String name = this.myName;
            int i = 1;
            MultiMap confl = new MultiMap();
            while (!GroovyValidationUtil.validateNewParameterName(this.myParameter, (MultiMap<PsiElement, String>)confl, name)) {
                name = this.myName + i;
                ++i;
                confl = new MultiMap();
            }
            return name;
        }
    }
}

