/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.GrMethodComparator;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;

class GroovyResolverProcessorImpl
extends GroovyResolverProcessor
implements GrMethodComparator.Context {
    GroovyResolverProcessorImpl(@NotNull GrReferenceExpression ref, @NotNull EnumSet<GroovyResolveKind> kinds, boolean forceRValue) {
        if (ref == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(0);
        }
        if (kinds == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(1);
        }
        super(ref, kinds, forceRValue);
    }

    @Override
    @NotNull
    public List<GroovyResolveResult> getCandidates() {
        List<GroovyResolveResult> variables = this.getCandidates(GroovyResolveKind.VARIABLE);
        if (!variables.isEmpty()) {
            List<GroovyResolveResult> list = variables;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<GroovyResolveResult> methods = this.getCandidates(GroovyResolveKind.METHOD);
        if (!methods.isEmpty()) {
            List<GroovyResolveResult> list = this.filterMethodCandidates(methods);
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        List properties = this.getCandidates(GroovyResolveKind.PROPERTY);
        if (!properties.isEmpty()) {
            List list = properties.size() <= 1 ? properties : ContainerUtil.newSmartList((Object)properties.get(0));
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<GroovyResolveResult> fields = this.getCandidates(GroovyResolveKind.FIELD);
        if (!fields.isEmpty()) {
            List<GroovyResolveResult> list = fields;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (!properties.isEmpty()) {
            List list = properties;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<GroovyResolveResult> bindings = this.getCandidates(GroovyResolveKind.BINDING);
        if (!bindings.isEmpty()) {
            List<GroovyResolveResult> list = bindings;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<GroovyResolveResult> list = this.getAllCandidates();
        if (list == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    protected List<GroovyResolveResult> getAllCandidates() {
        for (GroovyResolveKind kind : this.myAcceptableKinds) {
            List<GroovyResolveResult> results = this.getAllCandidates(kind);
            if (results.isEmpty()) continue;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])ResolveUtil.filterSameSignatureCandidates(this.filterCorrectParameterCount(results)));
            if (arrayList == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(9);
            }
            return arrayList;
        }
        List<GroovyResolveResult> list = Collections.emptyList();
        if (list == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected List<GroovyResolveResult> filterCorrectParameterCount(Collection<? extends GroovyResolveResult> candidates) {
        PsiType[] argumentTypes = (PsiType[])this.myArgumentTypes.getValue();
        if (argumentTypes == null) {
            return ContainerUtil.newArrayList(candidates);
        }
        List result2 = ContainerUtil.newSmartList();
        for (GroovyResolveResult groovyResolveResult : candidates) {
            if (groovyResolveResult instanceof GroovyMethodResult) {
                if (((GroovyMethodResult)groovyResolveResult).getElement().getParameterList().getParametersCount() != argumentTypes.length) continue;
                result2.add(groovyResolveResult);
                continue;
            }
            result2.add(groovyResolveResult);
        }
        if (!result2.isEmpty()) {
            return result2;
        }
        return ContainerUtil.newArrayList(candidates);
    }

    protected List<GroovyResolveResult> filterMethodCandidates(List<GroovyResolveResult> candidates) {
        if (candidates.size() <= 1) {
            return candidates;
        }
        ArrayList results = ContainerUtil.newArrayList();
        Iterator<GroovyResolveResult> itr = candidates.iterator();
        results.add(itr.next());
        block0: while (itr.hasNext()) {
            GroovyResolveResult resolveResult = itr.next();
            if (resolveResult instanceof GroovyMethodResult) {
                Iterator iterator2 = results.iterator();
                while (iterator2.hasNext()) {
                    GroovyResolveResult otherResolveResult = (GroovyResolveResult)iterator2.next();
                    if (!(otherResolveResult instanceof GroovyMethodResult)) continue;
                    int res = GrMethodComparator.compareMethods((GroovyMethodResult)resolveResult, (GroovyMethodResult)otherResolveResult, this);
                    if (res > 0) continue block0;
                    if (res >= 0) continue;
                    iterator2.remove();
                }
            }
            results.add(resolveResult);
        }
        return results;
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        return (PsiType[])this.myArgumentTypes.getValue();
    }

    @Override
    @Nullable
    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        GrReferenceExpression grReferenceExpression = this.myRef;
        if (grReferenceExpression == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(11);
        }
        return grReferenceExpression;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCandidates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

